package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigItem invokes the cloudcallcenter.GetConfigItem API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconfigitem.html
func (client *Client) GetConfigItem(request *GetConfigItemRequest) (response *GetConfigItemResponse, err error) {
	response = CreateGetConfigItemResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigItemWithChan invokes the cloudcallcenter.GetConfigItem API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconfigitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetConfigItemWithChan(request *GetConfigItemRequest) (<-chan *GetConfigItemResponse, <-chan error) {
	responseChan := make(chan *GetConfigItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigItemWithCallback invokes the cloudcallcenter.GetConfigItem API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconfigitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetConfigItemWithCallback(request *GetConfigItemRequest, callback func(response *GetConfigItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigItemResponse
		var err error
		defer close(result)
		response, err = client.GetConfigItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigItemRequest is the request struct for api GetConfigItem
type GetConfigItemRequest struct {
	*requests.RpcRequest
	Inherit       requests.Boolean `position:"Query" name:"Inherit"`
	Name          string           `position:"Query" name:"Name"`
	DimensionName string           `position:"Query" name:"DimensionName"`
	Dimension     string           `position:"Query" name:"Dimension"`
}

// GetConfigItemResponse is the response struct for api GetConfigItem
type GetConfigItemResponse struct {
	*responses.BaseResponse
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Code           string     `json:"Code" xml:"Code"`
	Message        string     `json:"Message" xml:"Message"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ConfigItem     ConfigItem `json:"ConfigItem" xml:"ConfigItem"`
}

// CreateGetConfigItemRequest creates a request to invoke GetConfigItem API
func CreateGetConfigItemRequest() (request *GetConfigItemRequest) {
	request = &GetConfigItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetConfigItem", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConfigItemResponse creates a response to parse from GetConfigItem response
func CreateGetConfigItemResponse() (response *GetConfigItemResponse) {
	response = &GetConfigItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
