package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOssUploadToken invokes the cloudauth.DescribeOssUploadToken API synchronously
func (client *Client) DescribeOssUploadToken(request *DescribeOssUploadTokenRequest) (response *DescribeOssUploadTokenResponse, err error) {
	response = CreateDescribeOssUploadTokenResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOssUploadTokenWithChan invokes the cloudauth.DescribeOssUploadToken API asynchronously
func (client *Client) DescribeOssUploadTokenWithChan(request *DescribeOssUploadTokenRequest) (<-chan *DescribeOssUploadTokenResponse, <-chan error) {
	responseChan := make(chan *DescribeOssUploadTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOssUploadToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOssUploadTokenWithCallback invokes the cloudauth.DescribeOssUploadToken API asynchronously
func (client *Client) DescribeOssUploadTokenWithCallback(request *DescribeOssUploadTokenRequest, callback func(response *DescribeOssUploadTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOssUploadTokenResponse
		var err error
		defer close(result)
		response, err = client.DescribeOssUploadToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOssUploadTokenRequest is the request struct for api DescribeOssUploadToken
type DescribeOssUploadTokenRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeOssUploadTokenResponse is the response struct for api DescribeOssUploadToken
type DescribeOssUploadTokenResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	OssUploadToken OssUploadToken `json:"OssUploadToken" xml:"OssUploadToken"`
}

// CreateDescribeOssUploadTokenRequest creates a request to invoke DescribeOssUploadToken API
func CreateDescribeOssUploadTokenRequest() (request *DescribeOssUploadTokenRequest) {
	request = &DescribeOssUploadTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DescribeOssUploadToken", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOssUploadTokenResponse creates a response to parse from DescribeOssUploadToken response
func CreateDescribeOssUploadTokenResponse() (response *DescribeOssUploadTokenResponse) {
	response = &DescribeOssUploadTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
