package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBackupPlan invokes the cassandra.ModifyBackupPlan API synchronously
func (client *Client) ModifyBackupPlan(request *ModifyBackupPlanRequest) (response *ModifyBackupPlanResponse, err error) {
	response = CreateModifyBackupPlanResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBackupPlanWithChan invokes the cassandra.ModifyBackupPlan API asynchronously
func (client *Client) ModifyBackupPlanWithChan(request *ModifyBackupPlanRequest) (<-chan *ModifyBackupPlanResponse, <-chan error) {
	responseChan := make(chan *ModifyBackupPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBackupPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBackupPlanWithCallback invokes the cassandra.ModifyBackupPlan API asynchronously
func (client *Client) ModifyBackupPlanWithCallback(request *ModifyBackupPlanRequest, callback func(response *ModifyBackupPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBackupPlanResponse
		var err error
		defer close(result)
		response, err = client.ModifyBackupPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBackupPlanRequest is the request struct for api ModifyBackupPlan
type ModifyBackupPlanRequest struct {
	*requests.RpcRequest
	RetentionPeriod requests.Integer `position:"Query" name:"RetentionPeriod"`
	DataCenterId    string           `position:"Query" name:"DataCenterId"`
	Active          requests.Boolean `position:"Query" name:"Active"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	BackupTime      string           `position:"Query" name:"BackupTime"`
	BackupPeriod    string           `position:"Query" name:"BackupPeriod"`
}

// ModifyBackupPlanResponse is the response struct for api ModifyBackupPlan
type ModifyBackupPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyBackupPlanRequest creates a request to invoke ModifyBackupPlan API
func CreateModifyBackupPlanRequest() (request *ModifyBackupPlanRequest) {
	request = &ModifyBackupPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "ModifyBackupPlan", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyBackupPlanResponse creates a response to parse from ModifyBackupPlan response
func CreateModifyBackupPlanResponse() (response *ModifyBackupPlanResponse) {
	response = &ModifyBackupPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
