package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFabricChaincode invokes the baas.CreateFabricChaincode API synchronously
// api document: https://help.aliyun.com/api/baas/createfabricchaincode.html
func (client *Client) CreateFabricChaincode(request *CreateFabricChaincodeRequest) (response *CreateFabricChaincodeResponse, err error) {
	response = CreateCreateFabricChaincodeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFabricChaincodeWithChan invokes the baas.CreateFabricChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricchaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricChaincodeWithChan(request *CreateFabricChaincodeRequest) (<-chan *CreateFabricChaincodeResponse, <-chan error) {
	responseChan := make(chan *CreateFabricChaincodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFabricChaincode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFabricChaincodeWithCallback invokes the baas.CreateFabricChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricchaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricChaincodeWithCallback(request *CreateFabricChaincodeRequest, callback func(response *CreateFabricChaincodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFabricChaincodeResponse
		var err error
		defer close(result)
		response, err = client.CreateFabricChaincode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFabricChaincodeRequest is the request struct for api CreateFabricChaincode
type CreateFabricChaincodeRequest struct {
	*requests.RpcRequest
	EndorsePolicy  string `position:"Body" name:"EndorsePolicy"`
	OssBucket      string `position:"Body" name:"OssBucket"`
	OrganizationId string `position:"Body" name:"OrganizationId"`
	OssUrl         string `position:"Body" name:"OssUrl"`
	Location       string `position:"Body" name:"Location"`
	ChannelId      string `position:"Body" name:"ChannelId"`
	ConsortiumId   string `position:"Body" name:"ConsortiumId"`
}

// CreateFabricChaincodeResponse is the response struct for api CreateFabricChaincode
type CreateFabricChaincodeResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	Success   bool                          `json:"Success" xml:"Success"`
	ErrorCode int                           `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInCreateFabricChaincode `json:"Result" xml:"Result"`
}

// CreateCreateFabricChaincodeRequest creates a request to invoke CreateFabricChaincode API
func CreateCreateFabricChaincodeRequest() (request *CreateFabricChaincodeRequest) {
	request = &CreateFabricChaincodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateFabricChaincode", "baas", "openAPI")
	return
}

// CreateCreateFabricChaincodeResponse creates a response to parse from CreateFabricChaincode response
func CreateCreateFabricChaincodeResponse() (response *CreateFabricChaincodeResponse) {
	response = &CreateFabricChaincodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
