#!/bin/sh

# This test ensures that the n-place directive is working correctly.

set -e
set -u
set -x

cleanup() {
	rm -f ./inplace-script-input.json inplace-script-reference.json
}
cleanup
trap cleanup EXIT

cp ../../doc/data/iata.json ./inplace-script-input.json

# convert to just a list of airport codes, and lowercase them
"$RQ" -I inplace-script-input.json -O inplace-script-reference.json '{lower(k) | input[k]}'

"$RQ" script ./script.rego

diff inplace-script-input.json inplace-script-reference.json
