/*****************************************************************************/
/*									     */
/*				   NLSINIT.CC				     */
/*									     */
/* (C) 1993-96	Ullrich von Bassewitz					     */
/*		Wacholderweg 14						     */
/*		D-70597 Stuttgart					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// 32-bit (Watcom) version of nlsinit module. The code below is not compatible
// with the 16-bit version since the pmode/w DOS extender does not support the
// dos call used, so we have to work around it.



#include <i86.h>
#include <conio.h>

#include "check.h"
#include "environ.h"
#include "national.h"



/*****************************************************************************/
/*				Types and data				     */
/*****************************************************************************/



// Structure that holds the real mode registers in an simulated real mode int
struct RealModeRegs {
    u32 edi;
    u32 esi;
    u32 ebp;
    u32 reserved_by_system;
    u32 ebx;
    u32 edx;
    u32 ecx;
    u32 eax;
    u16 flags;
    u16 es,ds,fs,gs,ip,cs,sp,ss;
};



// Country info struct from DOS
#pragma PACK(1)
struct CountryInfo {
    char	ID;
    u16		Size;
    u16		Country;
    u16		CodePage;
    u16		Date;
    char	CurrStr [5];
    char	ThSep [2];
    char	DecSep [2];
    char	DateSep [2];
    char	TimeSep [2];
    char	Curr;
    char	CurrPlaces;
    char	Time;
    u32		CaseMapFunc;
    char	DataSep [2];
    char	Fill [10];
};
#pragma PACK()



// Translation table from the input character set to the internal used
// character set. On DOS/OS2 this is a no-op, but will change if more
// codepages are supported.
static _NLSTransTable InputMap = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
    0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
    0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
    0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
    0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF
};

// Translation table from the internal used character set to the output
// character set. On DOS/OS2 this is a no-op, but will change if more
// codepages are supported.
static _NLSTransTable OutputMap = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
    0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
    0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
    0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
    0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF
};



// External references to above tables
const _NLSTransTable& NLSInputMap	= InputMap;
const _NLSTransTable& NLSOutputMap	= OutputMap;



/*****************************************************************************/
/*				     Code				     */
/*****************************************************************************/



static void GetCountryInfo (void far* InfoStruct, u16 InfoLen, unsigned char ID)
{
    REGS Regs;
    SREGS SRegs;
    RealModeRegs RMRegs;

    // Allocate a real mode memory block big enough
    Regs.w.ax = 0x0100;
    Regs.w.bx = (InfoLen + 15) / 16;   // Memory in paras
    int386 (0x31, &Regs, &Regs);
    u16 Segment  = Regs.w.ax;
    u16 Selector = Regs.w.dx;

    // Set up the registers for the simulated real mode interrupt
    memset (&RMRegs, 0, sizeof (RMRegs));
    RMRegs.eax	= 0x6500 | ID;
    RMRegs.ebx	= (u32) -1;
    RMRegs.ecx	= InfoLen;
    RMRegs.edx	= (u32) -1;
    RMRegs.edi	= 0;			// Offset of low memory block
    RMRegs.es	= Segment;		// Segment of low memory block

    // Use the DPMI function 300h to simulate the real mode int
    memset (&SRegs, 0, sizeof (SRegs));
    Regs.w.ax  = 0x0300;
    Regs.w.bx  = 0x0021;
    Regs.w.cx  = 0x0000;
    SRegs.es   = FP_SEG (&RMRegs);
    Regs.x.edi = FP_OFF (&RMRegs);
    int386x (0x31, &Regs, &Regs, &SRegs);

    // Copy the data from real mode memory
    _fmemcpy (InfoStruct, MK_FP (Selector, 0), InfoLen);

    // Free the real mode memory block
    Regs.w.ax = 0x101;
    Regs.w.dx = Selector;
    int386 (0x31, &Regs, &Regs);
}



void NLSInit ()
// Sets up the data for the NLS. This function has to be called before any call
// to another function in this module!
{
    CountryInfo Info;

    // Get country information
    GetCountryInfo (&Info, sizeof (Info), 0x01);

    // Try if there is an override for the country in the environment
    unsigned Country = GetEnvNum ("SPUNK_COUNTRY", Info.Country);

    // Set the country data
    NLSSetCountry (Country);

    // Try if there is an override for the language in the environment
    unsigned Language = GetEnvNum ("SPUNK_LANGUAGE", NLSGetDefaultLanguage (Country));

    // Set the language
    NLSSetLanguage (Language);

}



