#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag / commit.
REPO='https://chromium.googlesource.com/webm/libvpx'; TAG='v1.15.1-rc1'
git clone "$REPO" --depth=1 --branch="${TAG}" /vpx
cd /vpx

# Configure build.
./configure --target=generic-gnu \
            --prefix=/vendor \
            --disable-dependency-tracking \
            --disable-optimizations \
            --disable-pic \
            --enable-shared \
            --enable-static \
            --disable-multithread \
            --enable-vp8 \
            --enable-vp9 \
            --enable-vp9-highbitdepth \
            --enable-webm-io \
            --enable-multi-res-encoding \
            --enable-realtime-only \
            --disable-tools \
            --disable-examples \
            --disable-docs \
|| { cat config.log; exit 1; }

# Perform build + install.
make -j $(nproc) install
