// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/maps/routing/v2/routes_service.proto

package routingpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	localized_text "google.golang.org/genproto/googleapis/type/localized_text"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The condition of the route being returned.
type RouteMatrixElementCondition int32

const (
	// Only used when the `status` of the element is not OK.
	RouteMatrixElementCondition_ROUTE_MATRIX_ELEMENT_CONDITION_UNSPECIFIED RouteMatrixElementCondition = 0
	// A route was found, and the corresponding information was filled out for the
	// element.
	RouteMatrixElementCondition_ROUTE_EXISTS RouteMatrixElementCondition = 1
	// No route could be found. Fields containing route information, such as
	// `distance_meters` or `duration`, will not be filled out in the element.
	RouteMatrixElementCondition_ROUTE_NOT_FOUND RouteMatrixElementCondition = 2
)

// Enum value maps for RouteMatrixElementCondition.
var (
	RouteMatrixElementCondition_name = map[int32]string{
		0: "ROUTE_MATRIX_ELEMENT_CONDITION_UNSPECIFIED",
		1: "ROUTE_EXISTS",
		2: "ROUTE_NOT_FOUND",
	}
	RouteMatrixElementCondition_value = map[string]int32{
		"ROUTE_MATRIX_ELEMENT_CONDITION_UNSPECIFIED": 0,
		"ROUTE_EXISTS":    1,
		"ROUTE_NOT_FOUND": 2,
	}
)

func (x RouteMatrixElementCondition) Enum() *RouteMatrixElementCondition {
	p := new(RouteMatrixElementCondition)
	*p = x
	return p
}

func (x RouteMatrixElementCondition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteMatrixElementCondition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_routing_v2_routes_service_proto_enumTypes[0].Descriptor()
}

func (RouteMatrixElementCondition) Type() protoreflect.EnumType {
	return &file_google_maps_routing_v2_routes_service_proto_enumTypes[0]
}

func (x RouteMatrixElementCondition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteMatrixElementCondition.Descriptor instead.
func (RouteMatrixElementCondition) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{0}
}

// A supported reference route on the ComputeRoutesRequest.
type ComputeRoutesRequest_ReferenceRoute int32

const (
	// Not used. Requests containing this value fail.
	ComputeRoutesRequest_REFERENCE_ROUTE_UNSPECIFIED ComputeRoutesRequest_ReferenceRoute = 0
	// Fuel efficient route. Routes labeled with this value are determined to be
	// optimized for parameters such as fuel consumption.
	ComputeRoutesRequest_FUEL_EFFICIENT ComputeRoutesRequest_ReferenceRoute = 1
)

// Enum value maps for ComputeRoutesRequest_ReferenceRoute.
var (
	ComputeRoutesRequest_ReferenceRoute_name = map[int32]string{
		0: "REFERENCE_ROUTE_UNSPECIFIED",
		1: "FUEL_EFFICIENT",
	}
	ComputeRoutesRequest_ReferenceRoute_value = map[string]int32{
		"REFERENCE_ROUTE_UNSPECIFIED": 0,
		"FUEL_EFFICIENT":              1,
	}
)

func (x ComputeRoutesRequest_ReferenceRoute) Enum() *ComputeRoutesRequest_ReferenceRoute {
	p := new(ComputeRoutesRequest_ReferenceRoute)
	*p = x
	return p
}

func (x ComputeRoutesRequest_ReferenceRoute) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeRoutesRequest_ReferenceRoute) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_routing_v2_routes_service_proto_enumTypes[1].Descriptor()
}

func (ComputeRoutesRequest_ReferenceRoute) Type() protoreflect.EnumType {
	return &file_google_maps_routing_v2_routes_service_proto_enumTypes[1]
}

func (x ComputeRoutesRequest_ReferenceRoute) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeRoutesRequest_ReferenceRoute.Descriptor instead.
func (ComputeRoutesRequest_ReferenceRoute) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{0, 0}
}

// Extra computations to perform while completing the request.
type ComputeRoutesRequest_ExtraComputation int32

const (
	// Not used. Requests containing this value will fail.
	ComputeRoutesRequest_EXTRA_COMPUTATION_UNSPECIFIED ComputeRoutesRequest_ExtraComputation = 0
	// Toll information for the route(s).
	ComputeRoutesRequest_TOLLS ComputeRoutesRequest_ExtraComputation = 1
	// Estimated fuel consumption for the route(s).
	ComputeRoutesRequest_FUEL_CONSUMPTION ComputeRoutesRequest_ExtraComputation = 2
	// Traffic aware polylines for the route(s).
	ComputeRoutesRequest_TRAFFIC_ON_POLYLINE ComputeRoutesRequest_ExtraComputation = 3
	// [`NavigationInstructions`](google.maps.routing.v2.NavigationInstructions.instructions)
	// presented as a formatted HTML text string. This content
	// is meant to be read as-is. This content is for display only.
	// Do not programmatically parse it.
	ComputeRoutesRequest_HTML_FORMATTED_NAVIGATION_INSTRUCTIONS ComputeRoutesRequest_ExtraComputation = 4
)

// Enum value maps for ComputeRoutesRequest_ExtraComputation.
var (
	ComputeRoutesRequest_ExtraComputation_name = map[int32]string{
		0: "EXTRA_COMPUTATION_UNSPECIFIED",
		1: "TOLLS",
		2: "FUEL_CONSUMPTION",
		3: "TRAFFIC_ON_POLYLINE",
		4: "HTML_FORMATTED_NAVIGATION_INSTRUCTIONS",
	}
	ComputeRoutesRequest_ExtraComputation_value = map[string]int32{
		"EXTRA_COMPUTATION_UNSPECIFIED":          0,
		"TOLLS":                                  1,
		"FUEL_CONSUMPTION":                       2,
		"TRAFFIC_ON_POLYLINE":                    3,
		"HTML_FORMATTED_NAVIGATION_INSTRUCTIONS": 4,
	}
)

func (x ComputeRoutesRequest_ExtraComputation) Enum() *ComputeRoutesRequest_ExtraComputation {
	p := new(ComputeRoutesRequest_ExtraComputation)
	*p = x
	return p
}

func (x ComputeRoutesRequest_ExtraComputation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeRoutesRequest_ExtraComputation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_routing_v2_routes_service_proto_enumTypes[2].Descriptor()
}

func (ComputeRoutesRequest_ExtraComputation) Type() protoreflect.EnumType {
	return &file_google_maps_routing_v2_routes_service_proto_enumTypes[2]
}

func (x ComputeRoutesRequest_ExtraComputation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeRoutesRequest_ExtraComputation.Descriptor instead.
func (ComputeRoutesRequest_ExtraComputation) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{0, 1}
}

// Extra computations to perform while completing the request.
type ComputeRouteMatrixRequest_ExtraComputation int32

const (
	// Not used. Requests containing this value will fail.
	ComputeRouteMatrixRequest_EXTRA_COMPUTATION_UNSPECIFIED ComputeRouteMatrixRequest_ExtraComputation = 0
	// Toll information for the matrix element(s).
	ComputeRouteMatrixRequest_TOLLS ComputeRouteMatrixRequest_ExtraComputation = 1
)

// Enum value maps for ComputeRouteMatrixRequest_ExtraComputation.
var (
	ComputeRouteMatrixRequest_ExtraComputation_name = map[int32]string{
		0: "EXTRA_COMPUTATION_UNSPECIFIED",
		1: "TOLLS",
	}
	ComputeRouteMatrixRequest_ExtraComputation_value = map[string]int32{
		"EXTRA_COMPUTATION_UNSPECIFIED": 0,
		"TOLLS":                         1,
	}
)

func (x ComputeRouteMatrixRequest_ExtraComputation) Enum() *ComputeRouteMatrixRequest_ExtraComputation {
	p := new(ComputeRouteMatrixRequest_ExtraComputation)
	*p = x
	return p
}

func (x ComputeRouteMatrixRequest_ExtraComputation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeRouteMatrixRequest_ExtraComputation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_routing_v2_routes_service_proto_enumTypes[3].Descriptor()
}

func (ComputeRouteMatrixRequest_ExtraComputation) Type() protoreflect.EnumType {
	return &file_google_maps_routing_v2_routes_service_proto_enumTypes[3]
}

func (x ComputeRouteMatrixRequest_ExtraComputation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeRouteMatrixRequest_ExtraComputation.Descriptor instead.
func (ComputeRouteMatrixRequest_ExtraComputation) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{2, 0}
}

// ComputeRoutes request message.
type ComputeRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Origin waypoint.
	Origin *Waypoint `protobuf:"bytes,1,opt,name=origin,proto3" json:"origin,omitempty"`
	// Required. Destination waypoint.
	Destination *Waypoint `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. A set of waypoints along the route (excluding terminal points),
	// for either stopping at or passing by. Up to 25 intermediate waypoints are
	// supported.
	Intermediates []*Waypoint `protobuf:"bytes,3,rep,name=intermediates,proto3" json:"intermediates,omitempty"`
	// Optional. Specifies the mode of transportation.
	TravelMode RouteTravelMode `protobuf:"varint,4,opt,name=travel_mode,json=travelMode,proto3,enum=google.maps.routing.v2.RouteTravelMode" json:"travel_mode,omitempty"`
	// Optional. Specifies how to compute the route. The server
	// attempts to use the selected routing preference to compute the route. If
	//
	//	the routing preference results in an error or an extra long latency, then
	//
	// an error is returned. You can specify this option only when the
	// `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
	RoutingPreference RoutingPreference `protobuf:"varint,5,opt,name=routing_preference,json=routingPreference,proto3,enum=google.maps.routing.v2.RoutingPreference" json:"routing_preference,omitempty"`
	// Optional. Specifies your preference for the quality of the polyline.
	PolylineQuality PolylineQuality `protobuf:"varint,6,opt,name=polyline_quality,json=polylineQuality,proto3,enum=google.maps.routing.v2.PolylineQuality" json:"polyline_quality,omitempty"`
	// Optional. Specifies the preferred encoding for the polyline.
	PolylineEncoding PolylineEncoding `protobuf:"varint,12,opt,name=polyline_encoding,json=polylineEncoding,proto3,enum=google.maps.routing.v2.PolylineEncoding" json:"polyline_encoding,omitempty"`
	// Optional. The departure time. If you don't set this value, then this value
	// defaults to the time that you made the request.
	// NOTE: You can only specify a `departure_time` in the past when
	// [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
	// `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
	// days in the future.
	DepartureTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=departure_time,json=departureTime,proto3" json:"departure_time,omitempty"`
	// Optional. The arrival time.
	// NOTE: Can only be set when
	// [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
	// `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
	// not both. Transit trips are available for up to 7 days in the past or 100
	// days in the future.
	ArrivalTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=arrival_time,json=arrivalTime,proto3" json:"arrival_time,omitempty"`
	// Optional. Specifies whether to calculate alternate routes in addition to
	// the route. No alternative routes are returned for requests that have
	// intermediate waypoints.
	ComputeAlternativeRoutes bool `protobuf:"varint,8,opt,name=compute_alternative_routes,json=computeAlternativeRoutes,proto3" json:"compute_alternative_routes,omitempty"`
	// Optional. A set of conditions to satisfy that affect the way routes are
	// calculated.
	RouteModifiers *RouteModifiers `protobuf:"bytes,9,opt,name=route_modifiers,json=routeModifiers,proto3" json:"route_modifiers,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see [Unicode Locale
	// Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
	// See [Language
	// Support](https://developers.google.com/maps/faq#languagesupport)
	// for the list of supported languages. When you don't provide this value, the
	// display language is inferred from the location of the route request.
	LanguageCode string `protobuf:"bytes,10,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The region code, specified as a ccTLD ("top-level domain")
	// two-character value. For more information see [Country code top-level
	// domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
	RegionCode string `protobuf:"bytes,16,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional. Specifies the units of measure for the display fields. These
	// fields include the `instruction` field in
	// [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
	// The units of measure used for the route, leg, step distance, and duration
	// are not affected by this value. If you don't provide this value, then the
	// display units are inferred from the location of the first origin.
	Units Units `protobuf:"varint,11,opt,name=units,proto3,enum=google.maps.routing.v2.Units" json:"units,omitempty"`
	// Optional. If set to true, the service attempts to minimize the overall cost
	// of the route by re-ordering the specified intermediate waypoints. The
	// request fails if any of the intermediate waypoints is a `via` waypoint. Use
	// `ComputeRoutesResponse.Routes.optimized_intermediate_waypoint_index` to
	// find the new ordering.
	// If `ComputeRoutesResponseroutes.optimized_intermediate_waypoint_index` is
	// not requested in the `X-Goog-FieldMask` header, the request fails.
	// If `optimize_waypoint_order` is set to false,
	// `ComputeRoutesResponse.optimized_intermediate_waypoint_index` will be
	// empty.
	OptimizeWaypointOrder bool `protobuf:"varint,13,opt,name=optimize_waypoint_order,json=optimizeWaypointOrder,proto3" json:"optimize_waypoint_order,omitempty"`
	// Optional. Specifies what reference routes to calculate as part of the
	// request in addition to the default route. A reference route is a route with
	// a different route calculation objective than the default route. For example
	// a `FUEL_EFFICIENT` reference route calculation takes into account various
	// parameters that would generate an optimal fuel efficient route.
	RequestedReferenceRoutes []ComputeRoutesRequest_ReferenceRoute `protobuf:"varint,14,rep,packed,name=requested_reference_routes,json=requestedReferenceRoutes,proto3,enum=google.maps.routing.v2.ComputeRoutesRequest_ReferenceRoute" json:"requested_reference_routes,omitempty"`
	// Optional. A list of extra computations which may be used to complete the
	// request. Note: These extra computations may return extra fields on the
	// response. These extra fields must also be specified in the field mask to be
	// returned in the response.
	ExtraComputations []ComputeRoutesRequest_ExtraComputation `protobuf:"varint,15,rep,packed,name=extra_computations,json=extraComputations,proto3,enum=google.maps.routing.v2.ComputeRoutesRequest_ExtraComputation" json:"extra_computations,omitempty"`
	// Optional. Specifies the assumptions to use when calculating time in
	// traffic. This setting affects the value returned in the duration field in
	// the
	// [`Route`][google.maps.routing.v2.Route] and
	// [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
	// time in traffic based on historical averages.
	// `TrafficModel` is only available for requests that have set
	// [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
	// `TRAFFIC_AWARE_OPTIMAL` and
	// [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
	// Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
	// specified.
	TrafficModel TrafficModel `protobuf:"varint,18,opt,name=traffic_model,json=trafficModel,proto3,enum=google.maps.routing.v2.TrafficModel" json:"traffic_model,omitempty"`
	// Optional. Specifies preferences that influence the route returned for
	// `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
	// [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
	// `TRANSIT`.
	TransitPreferences *TransitPreferences `protobuf:"bytes,20,opt,name=transit_preferences,json=transitPreferences,proto3" json:"transit_preferences,omitempty"`
}

func (x *ComputeRoutesRequest) Reset() {
	*x = ComputeRoutesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeRoutesRequest) ProtoMessage() {}

func (x *ComputeRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeRoutesRequest.ProtoReflect.Descriptor instead.
func (*ComputeRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{0}
}

func (x *ComputeRoutesRequest) GetOrigin() *Waypoint {
	if x != nil {
		return x.Origin
	}
	return nil
}

func (x *ComputeRoutesRequest) GetDestination() *Waypoint {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ComputeRoutesRequest) GetIntermediates() []*Waypoint {
	if x != nil {
		return x.Intermediates
	}
	return nil
}

func (x *ComputeRoutesRequest) GetTravelMode() RouteTravelMode {
	if x != nil {
		return x.TravelMode
	}
	return RouteTravelMode_TRAVEL_MODE_UNSPECIFIED
}

func (x *ComputeRoutesRequest) GetRoutingPreference() RoutingPreference {
	if x != nil {
		return x.RoutingPreference
	}
	return RoutingPreference_ROUTING_PREFERENCE_UNSPECIFIED
}

func (x *ComputeRoutesRequest) GetPolylineQuality() PolylineQuality {
	if x != nil {
		return x.PolylineQuality
	}
	return PolylineQuality_POLYLINE_QUALITY_UNSPECIFIED
}

func (x *ComputeRoutesRequest) GetPolylineEncoding() PolylineEncoding {
	if x != nil {
		return x.PolylineEncoding
	}
	return PolylineEncoding_POLYLINE_ENCODING_UNSPECIFIED
}

func (x *ComputeRoutesRequest) GetDepartureTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DepartureTime
	}
	return nil
}

func (x *ComputeRoutesRequest) GetArrivalTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ArrivalTime
	}
	return nil
}

func (x *ComputeRoutesRequest) GetComputeAlternativeRoutes() bool {
	if x != nil {
		return x.ComputeAlternativeRoutes
	}
	return false
}

func (x *ComputeRoutesRequest) GetRouteModifiers() *RouteModifiers {
	if x != nil {
		return x.RouteModifiers
	}
	return nil
}

func (x *ComputeRoutesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ComputeRoutesRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *ComputeRoutesRequest) GetUnits() Units {
	if x != nil {
		return x.Units
	}
	return Units_UNITS_UNSPECIFIED
}

func (x *ComputeRoutesRequest) GetOptimizeWaypointOrder() bool {
	if x != nil {
		return x.OptimizeWaypointOrder
	}
	return false
}

func (x *ComputeRoutesRequest) GetRequestedReferenceRoutes() []ComputeRoutesRequest_ReferenceRoute {
	if x != nil {
		return x.RequestedReferenceRoutes
	}
	return nil
}

func (x *ComputeRoutesRequest) GetExtraComputations() []ComputeRoutesRequest_ExtraComputation {
	if x != nil {
		return x.ExtraComputations
	}
	return nil
}

func (x *ComputeRoutesRequest) GetTrafficModel() TrafficModel {
	if x != nil {
		return x.TrafficModel
	}
	return TrafficModel_TRAFFIC_MODEL_UNSPECIFIED
}

func (x *ComputeRoutesRequest) GetTransitPreferences() *TransitPreferences {
	if x != nil {
		return x.TransitPreferences
	}
	return nil
}

// ComputeRoutes the response message.
type ComputeRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains an array of computed routes (up to three) when you specify
	// `compute_alternatives_routes`, and contains just one route when you don't.
	// When this array contains multiple entries, the first one is the most
	// recommended route. If the array is empty, then it means no route could be
	// found.
	Routes []*Route `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	// In some cases when the server is not able to compute the route results with
	// all of the input preferences, it may fallback to using a different way of
	// computation. When fallback mode is used, this field contains detailed info
	// about the fallback response. Otherwise this field is unset.
	FallbackInfo *FallbackInfo `protobuf:"bytes,2,opt,name=fallback_info,json=fallbackInfo,proto3" json:"fallback_info,omitempty"`
	// Contains geocoding response info for waypoints specified as addresses.
	GeocodingResults *GeocodingResults `protobuf:"bytes,3,opt,name=geocoding_results,json=geocodingResults,proto3" json:"geocoding_results,omitempty"`
}

func (x *ComputeRoutesResponse) Reset() {
	*x = ComputeRoutesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeRoutesResponse) ProtoMessage() {}

func (x *ComputeRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeRoutesResponse.ProtoReflect.Descriptor instead.
func (*ComputeRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{1}
}

func (x *ComputeRoutesResponse) GetRoutes() []*Route {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *ComputeRoutesResponse) GetFallbackInfo() *FallbackInfo {
	if x != nil {
		return x.FallbackInfo
	}
	return nil
}

func (x *ComputeRoutesResponse) GetGeocodingResults() *GeocodingResults {
	if x != nil {
		return x.GeocodingResults
	}
	return nil
}

// ComputeRouteMatrix request message
type ComputeRouteMatrixRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Array of origins, which determines the rows of the response
	// matrix. Several size restrictions apply to the cardinality of origins and
	// destinations:
	//
	// * The sum of the number of origins + the number of destinations specified
	// as either `place_id` or `address` must be no greater than 50.
	// * The product of number of origins × number of destinations must be no
	// greater than 625 in any case.
	// * The product of the number of origins × number of destinations must be no
	// greater than 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
	// * The product of the number of origins × number of destinations must be no
	// greater than 100 if travel_mode is set to `TRANSIT`.
	Origins []*RouteMatrixOrigin `protobuf:"bytes,1,rep,name=origins,proto3" json:"origins,omitempty"`
	// Required. Array of destinations, which determines the columns of the
	// response matrix.
	Destinations []*RouteMatrixDestination `protobuf:"bytes,2,rep,name=destinations,proto3" json:"destinations,omitempty"`
	// Optional. Specifies the mode of transportation.
	TravelMode RouteTravelMode `protobuf:"varint,3,opt,name=travel_mode,json=travelMode,proto3,enum=google.maps.routing.v2.RouteTravelMode" json:"travel_mode,omitempty"`
	// Optional. Specifies how to compute the route. The server attempts to use
	// the selected routing preference to compute the route. If the routing
	// preference results in an error or an extra long latency, an error is
	// returned. You can specify this option only when the `travel_mode` is
	// `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
	RoutingPreference RoutingPreference `protobuf:"varint,4,opt,name=routing_preference,json=routingPreference,proto3,enum=google.maps.routing.v2.RoutingPreference" json:"routing_preference,omitempty"`
	// Optional. The departure time. If you don't set this value, then this value
	// defaults to the time that you made the request.
	// NOTE: You can only specify a `departure_time` in the past when
	// [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
	// `TRANSIT`.
	DepartureTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=departure_time,json=departureTime,proto3" json:"departure_time,omitempty"`
	// Optional. The arrival time.
	// NOTE: Can only be set when
	// [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
	// `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
	// not both.
	ArrivalTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=arrival_time,json=arrivalTime,proto3" json:"arrival_time,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see [Unicode Locale
	// Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
	// See [Language
	// Support](https://developers.google.com/maps/faq#languagesupport)
	// for the list of supported languages. When you don't provide this value, the
	// display language is inferred from the location of the first origin.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The region code, specified as a ccTLD ("top-level domain")
	// two-character value. For more information see [Country code top-level
	// domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
	RegionCode string `protobuf:"bytes,9,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional. Specifies the units of measure for the display fields.
	Units Units `protobuf:"varint,7,opt,name=units,proto3,enum=google.maps.routing.v2.Units" json:"units,omitempty"`
	// Optional. A list of extra computations which may be used to complete the
	// request. Note: These extra computations may return extra fields on the
	// response. These extra fields must also be specified in the field mask to be
	// returned in the response.
	ExtraComputations []ComputeRouteMatrixRequest_ExtraComputation `protobuf:"varint,8,rep,packed,name=extra_computations,json=extraComputations,proto3,enum=google.maps.routing.v2.ComputeRouteMatrixRequest_ExtraComputation" json:"extra_computations,omitempty"`
	// Optional. Specifies the assumptions to use when calculating time in
	// traffic. This setting affects the value returned in the duration field in
	// the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
	// contains the predicted time in traffic based on historical averages.
	// [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
	// `TRAFFIC_AWARE_OPTIMAL` and
	// [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
	// Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
	// specified.
	TrafficModel TrafficModel `protobuf:"varint,10,opt,name=traffic_model,json=trafficModel,proto3,enum=google.maps.routing.v2.TrafficModel" json:"traffic_model,omitempty"`
	// Optional. Specifies preferences that influence the route returned for
	// `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
	// [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
	// `TRANSIT`.
	TransitPreferences *TransitPreferences `protobuf:"bytes,12,opt,name=transit_preferences,json=transitPreferences,proto3" json:"transit_preferences,omitempty"`
}

func (x *ComputeRouteMatrixRequest) Reset() {
	*x = ComputeRouteMatrixRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeRouteMatrixRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeRouteMatrixRequest) ProtoMessage() {}

func (x *ComputeRouteMatrixRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeRouteMatrixRequest.ProtoReflect.Descriptor instead.
func (*ComputeRouteMatrixRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{2}
}

func (x *ComputeRouteMatrixRequest) GetOrigins() []*RouteMatrixOrigin {
	if x != nil {
		return x.Origins
	}
	return nil
}

func (x *ComputeRouteMatrixRequest) GetDestinations() []*RouteMatrixDestination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

func (x *ComputeRouteMatrixRequest) GetTravelMode() RouteTravelMode {
	if x != nil {
		return x.TravelMode
	}
	return RouteTravelMode_TRAVEL_MODE_UNSPECIFIED
}

func (x *ComputeRouteMatrixRequest) GetRoutingPreference() RoutingPreference {
	if x != nil {
		return x.RoutingPreference
	}
	return RoutingPreference_ROUTING_PREFERENCE_UNSPECIFIED
}

func (x *ComputeRouteMatrixRequest) GetDepartureTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DepartureTime
	}
	return nil
}

func (x *ComputeRouteMatrixRequest) GetArrivalTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ArrivalTime
	}
	return nil
}

func (x *ComputeRouteMatrixRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ComputeRouteMatrixRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *ComputeRouteMatrixRequest) GetUnits() Units {
	if x != nil {
		return x.Units
	}
	return Units_UNITS_UNSPECIFIED
}

func (x *ComputeRouteMatrixRequest) GetExtraComputations() []ComputeRouteMatrixRequest_ExtraComputation {
	if x != nil {
		return x.ExtraComputations
	}
	return nil
}

func (x *ComputeRouteMatrixRequest) GetTrafficModel() TrafficModel {
	if x != nil {
		return x.TrafficModel
	}
	return TrafficModel_TRAFFIC_MODEL_UNSPECIFIED
}

func (x *ComputeRouteMatrixRequest) GetTransitPreferences() *TransitPreferences {
	if x != nil {
		return x.TransitPreferences
	}
	return nil
}

// A single origin for ComputeRouteMatrixRequest
type RouteMatrixOrigin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Origin waypoint
	Waypoint *Waypoint `protobuf:"bytes,1,opt,name=waypoint,proto3" json:"waypoint,omitempty"`
	// Optional. Modifiers for every route that takes this as the origin
	RouteModifiers *RouteModifiers `protobuf:"bytes,2,opt,name=route_modifiers,json=routeModifiers,proto3" json:"route_modifiers,omitempty"`
}

func (x *RouteMatrixOrigin) Reset() {
	*x = RouteMatrixOrigin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteMatrixOrigin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteMatrixOrigin) ProtoMessage() {}

func (x *RouteMatrixOrigin) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteMatrixOrigin.ProtoReflect.Descriptor instead.
func (*RouteMatrixOrigin) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{3}
}

func (x *RouteMatrixOrigin) GetWaypoint() *Waypoint {
	if x != nil {
		return x.Waypoint
	}
	return nil
}

func (x *RouteMatrixOrigin) GetRouteModifiers() *RouteModifiers {
	if x != nil {
		return x.RouteModifiers
	}
	return nil
}

// A single destination for ComputeRouteMatrixRequest
type RouteMatrixDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Destination waypoint
	Waypoint *Waypoint `protobuf:"bytes,1,opt,name=waypoint,proto3" json:"waypoint,omitempty"`
}

func (x *RouteMatrixDestination) Reset() {
	*x = RouteMatrixDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteMatrixDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteMatrixDestination) ProtoMessage() {}

func (x *RouteMatrixDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteMatrixDestination.ProtoReflect.Descriptor instead.
func (*RouteMatrixDestination) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{4}
}

func (x *RouteMatrixDestination) GetWaypoint() *Waypoint {
	if x != nil {
		return x.Waypoint
	}
	return nil
}

// Contains route information computed for an origin/destination pair in the
// ComputeRouteMatrix API. This proto can be streamed to the client.
type RouteMatrixElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Zero-based index of the origin in the request.
	OriginIndex *int32 `protobuf:"varint,1,opt,name=origin_index,json=originIndex,proto3,oneof" json:"origin_index,omitempty"`
	// Zero-based index of the destination in the request.
	DestinationIndex *int32 `protobuf:"varint,2,opt,name=destination_index,json=destinationIndex,proto3,oneof" json:"destination_index,omitempty"`
	// Error status code for this element.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// Indicates whether the route was found or not. Independent of status.
	Condition RouteMatrixElementCondition `protobuf:"varint,9,opt,name=condition,proto3,enum=google.maps.routing.v2.RouteMatrixElementCondition" json:"condition,omitempty"`
	// The travel distance of the route, in meters.
	DistanceMeters int32 `protobuf:"varint,4,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
	// The length of time needed to navigate the route. If you set the
	// [routing_preference][google.maps.routing.v2.ComputeRouteMatrixRequest.routing_preference]
	// to `TRAFFIC_UNAWARE`, then this value is the same as `static_duration`. If
	// you set the `routing_preference` to either `TRAFFIC_AWARE` or
	// `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated taking traffic
	// conditions into account.
	Duration *durationpb.Duration `protobuf:"bytes,5,opt,name=duration,proto3" json:"duration,omitempty"`
	// The duration of traveling through the route without taking traffic
	// conditions into consideration.
	StaticDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
	// Additional information about the route. For example: restriction
	// information and toll information
	TravelAdvisory *RouteTravelAdvisory `protobuf:"bytes,7,opt,name=travel_advisory,json=travelAdvisory,proto3" json:"travel_advisory,omitempty"`
	// In some cases when the server is not able to compute the route with the
	// given preferences for this particular origin/destination pair, it may
	// fall back to using a different mode of computation. When fallback mode is
	// used, this field contains detailed information about the fallback response.
	// Otherwise this field is unset.
	FallbackInfo *FallbackInfo `protobuf:"bytes,8,opt,name=fallback_info,json=fallbackInfo,proto3" json:"fallback_info,omitempty"`
	// Text representations of properties of the `RouteMatrixElement`.
	LocalizedValues *RouteMatrixElement_LocalizedValues `protobuf:"bytes,10,opt,name=localized_values,json=localizedValues,proto3" json:"localized_values,omitempty"`
}

func (x *RouteMatrixElement) Reset() {
	*x = RouteMatrixElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteMatrixElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteMatrixElement) ProtoMessage() {}

func (x *RouteMatrixElement) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteMatrixElement.ProtoReflect.Descriptor instead.
func (*RouteMatrixElement) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{5}
}

func (x *RouteMatrixElement) GetOriginIndex() int32 {
	if x != nil && x.OriginIndex != nil {
		return *x.OriginIndex
	}
	return 0
}

func (x *RouteMatrixElement) GetDestinationIndex() int32 {
	if x != nil && x.DestinationIndex != nil {
		return *x.DestinationIndex
	}
	return 0
}

func (x *RouteMatrixElement) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *RouteMatrixElement) GetCondition() RouteMatrixElementCondition {
	if x != nil {
		return x.Condition
	}
	return RouteMatrixElementCondition_ROUTE_MATRIX_ELEMENT_CONDITION_UNSPECIFIED
}

func (x *RouteMatrixElement) GetDistanceMeters() int32 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

func (x *RouteMatrixElement) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *RouteMatrixElement) GetStaticDuration() *durationpb.Duration {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

func (x *RouteMatrixElement) GetTravelAdvisory() *RouteTravelAdvisory {
	if x != nil {
		return x.TravelAdvisory
	}
	return nil
}

func (x *RouteMatrixElement) GetFallbackInfo() *FallbackInfo {
	if x != nil {
		return x.FallbackInfo
	}
	return nil
}

func (x *RouteMatrixElement) GetLocalizedValues() *RouteMatrixElement_LocalizedValues {
	if x != nil {
		return x.LocalizedValues
	}
	return nil
}

// Text representations of certain properties.
type RouteMatrixElement_LocalizedValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Travel distance represented in text form.
	Distance *localized_text.LocalizedText `protobuf:"bytes,1,opt,name=distance,proto3" json:"distance,omitempty"`
	// Duration represented in text form taking traffic conditions into
	// consideration. Note: If traffic information was not requested, this value
	// is the same value as static_duration.
	Duration *localized_text.LocalizedText `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	// Duration represented in text form without taking traffic conditions into
	// consideration.
	StaticDuration *localized_text.LocalizedText `protobuf:"bytes,3,opt,name=static_duration,json=staticDuration,proto3" json:"static_duration,omitempty"`
	// Transit fare represented in text form.
	TransitFare *localized_text.LocalizedText `protobuf:"bytes,4,opt,name=transit_fare,json=transitFare,proto3" json:"transit_fare,omitempty"`
}

func (x *RouteMatrixElement_LocalizedValues) Reset() {
	*x = RouteMatrixElement_LocalizedValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteMatrixElement_LocalizedValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteMatrixElement_LocalizedValues) ProtoMessage() {}

func (x *RouteMatrixElement_LocalizedValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routing_v2_routes_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteMatrixElement_LocalizedValues.ProtoReflect.Descriptor instead.
func (*RouteMatrixElement_LocalizedValues) Descriptor() ([]byte, []int) {
	return file_google_maps_routing_v2_routes_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *RouteMatrixElement_LocalizedValues) GetDistance() *localized_text.LocalizedText {
	if x != nil {
		return x.Distance
	}
	return nil
}

func (x *RouteMatrixElement_LocalizedValues) GetDuration() *localized_text.LocalizedText {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *RouteMatrixElement_LocalizedValues) GetStaticDuration() *localized_text.LocalizedText {
	if x != nil {
		return x.StaticDuration
	}
	return nil
}

func (x *RouteMatrixElement_LocalizedValues) GetTransitFare() *localized_text.LocalizedText {
	if x != nil {
		return x.TransitFare
	}
	return nil
}

var File_google_maps_routing_v2_routes_service_proto protoreflect.FileDescriptor

var file_google_maps_routing_v2_routes_service_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76,
	0x32, 0x2f, 0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76,
	0x32, 0x2f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70,
	0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x5f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61,
	0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x2f, 0x77, 0x61,
	0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74, 0x65,
	0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc4, 0x0d, 0x0a, 0x14, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3d, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x61, 0x79, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x12, 0x47, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x57,
	0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0d, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x11, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x57, 0x0a, 0x10, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a,
	0x11, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x32, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e,
	0x65, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x46, 0x0a, 0x0e, 0x64, 0x65, 0x70,
	0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x42, 0x0a, 0x0c, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61,
	0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x5f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x0f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x28,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x38,
	0x0a, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x7e, 0x0a, 0x1a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x12, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x45, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x65, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4e, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x60, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x45, 0x0a, 0x0e, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x1b,
	0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x46, 0x55, 0x45, 0x4c, 0x5f, 0x45, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x10,
	0x01, 0x22, 0x9b, 0x01, 0x0a, 0x10, 0x45, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x58, 0x54, 0x52, 0x41, 0x5f,
	0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x4f, 0x4c,
	0x4c, 0x53, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x55, 0x45, 0x4c, 0x5f, 0x43, 0x4f, 0x4e,
	0x53, 0x55, 0x4d, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x52,
	0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x59, 0x4c, 0x49, 0x4e,
	0x45, 0x10, 0x03, 0x12, 0x2a, 0x0a, 0x26, 0x48, 0x54, 0x4d, 0x4c, 0x5f, 0x46, 0x4f, 0x52, 0x4d,
	0x41, 0x54, 0x54, 0x45, 0x44, 0x5f, 0x4e, 0x41, 0x56, 0x49, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x49, 0x4e, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x04, 0x22,
	0xf0, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x12, 0x49, 0x0a, 0x0d, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x66,
	0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x55, 0x0a, 0x11, 0x67,
	0x65, 0x6f, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e,
	0x47, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x52, 0x10, 0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x22, 0xee, 0x07, 0x0a, 0x19, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x07, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x73, 0x12, 0x57, 0x0a, 0x0c, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x46, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x61,
	0x72, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x61, 0x72, 0x72,
	0x69, 0x76, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x38, 0x0a,
	0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x76, 0x0a, 0x12, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x4e, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x60, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x22, 0x40, 0x0a, 0x10, 0x45, 0x78, 0x74, 0x72, 0x61, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x58, 0x54, 0x52, 0x41, 0x5f, 0x43,
	0x4f, 0x4d, 0x50, 0x55, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x4f, 0x4c, 0x4c,
	0x53, 0x10, 0x01, 0x22, 0xac, 0x01, 0x0a, 0x11, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x12, 0x41, 0x0a, 0x08, 0x77, 0x61, 0x79,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0f,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x73, 0x22, 0x5b, 0x0a, 0x16, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69,
	0x78, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x08,
	0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22,
	0xc8, 0x07, 0x0a, 0x12, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x45,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0b,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x30,
	0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x10, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01,
	0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x51, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x42, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x61, 0x64,
	0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x41, 0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x12, 0x49, 0x0a, 0x0d, 0x66, 0x61, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x65, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x85, 0x02, 0x0a, 0x0f,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x36, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x08, 0x64,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x43, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x54, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f,
	0x66, 0x61, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x46,
	0x61, 0x72, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2a, 0x74, 0x0a, 0x1b, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x2a, 0x52, 0x4f, 0x55,
	0x54, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x52, 0x49, 0x58, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x4f, 0x55,
	0x54, 0x45, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x02,
	0x32, 0xe4, 0x02, 0x0a, 0x06, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x95, 0x01, 0x0a, 0x0d,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x27, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x21, 0x3a, 0x01, 0x2a, 0x22, 0x1c, 0x2f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x76, 0x32, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72,
	0x69, 0x78, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2a, 0x3a, 0x01, 0x2a, 0x22, 0x25, 0x2f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x2f, 0x76, 0x32, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x30, 0x01, 0x1a, 0x18, 0xca,
	0x41, 0x15, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xc7, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x42, 0x12, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x05, 0x47, 0x4d,
	0x52, 0x56, 0x32, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70,
	0x73, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x16, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x52, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x4d, 0x61, 0x70, 0x73, 0x3a, 0x3a, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_routing_v2_routes_service_proto_rawDescOnce sync.Once
	file_google_maps_routing_v2_routes_service_proto_rawDescData = file_google_maps_routing_v2_routes_service_proto_rawDesc
)

func file_google_maps_routing_v2_routes_service_proto_rawDescGZIP() []byte {
	file_google_maps_routing_v2_routes_service_proto_rawDescOnce.Do(func() {
		file_google_maps_routing_v2_routes_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_routing_v2_routes_service_proto_rawDescData)
	})
	return file_google_maps_routing_v2_routes_service_proto_rawDescData
}

var file_google_maps_routing_v2_routes_service_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_maps_routing_v2_routes_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_maps_routing_v2_routes_service_proto_goTypes = []any{
	(RouteMatrixElementCondition)(0),                // 0: google.maps.routing.v2.RouteMatrixElementCondition
	(ComputeRoutesRequest_ReferenceRoute)(0),        // 1: google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute
	(ComputeRoutesRequest_ExtraComputation)(0),      // 2: google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation
	(ComputeRouteMatrixRequest_ExtraComputation)(0), // 3: google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation
	(*ComputeRoutesRequest)(nil),                    // 4: google.maps.routing.v2.ComputeRoutesRequest
	(*ComputeRoutesResponse)(nil),                   // 5: google.maps.routing.v2.ComputeRoutesResponse
	(*ComputeRouteMatrixRequest)(nil),               // 6: google.maps.routing.v2.ComputeRouteMatrixRequest
	(*RouteMatrixOrigin)(nil),                       // 7: google.maps.routing.v2.RouteMatrixOrigin
	(*RouteMatrixDestination)(nil),                  // 8: google.maps.routing.v2.RouteMatrixDestination
	(*RouteMatrixElement)(nil),                      // 9: google.maps.routing.v2.RouteMatrixElement
	(*RouteMatrixElement_LocalizedValues)(nil),      // 10: google.maps.routing.v2.RouteMatrixElement.LocalizedValues
	(*Waypoint)(nil),                                // 11: google.maps.routing.v2.Waypoint
	(RouteTravelMode)(0),                            // 12: google.maps.routing.v2.RouteTravelMode
	(RoutingPreference)(0),                          // 13: google.maps.routing.v2.RoutingPreference
	(PolylineQuality)(0),                            // 14: google.maps.routing.v2.PolylineQuality
	(PolylineEncoding)(0),                           // 15: google.maps.routing.v2.PolylineEncoding
	(*timestamppb.Timestamp)(nil),                   // 16: google.protobuf.Timestamp
	(*RouteModifiers)(nil),                          // 17: google.maps.routing.v2.RouteModifiers
	(Units)(0),                                      // 18: google.maps.routing.v2.Units
	(TrafficModel)(0),                               // 19: google.maps.routing.v2.TrafficModel
	(*TransitPreferences)(nil),                      // 20: google.maps.routing.v2.TransitPreferences
	(*Route)(nil),                                   // 21: google.maps.routing.v2.Route
	(*FallbackInfo)(nil),                            // 22: google.maps.routing.v2.FallbackInfo
	(*GeocodingResults)(nil),                        // 23: google.maps.routing.v2.GeocodingResults
	(*status.Status)(nil),                           // 24: google.rpc.Status
	(*durationpb.Duration)(nil),                     // 25: google.protobuf.Duration
	(*RouteTravelAdvisory)(nil),                     // 26: google.maps.routing.v2.RouteTravelAdvisory
	(*localized_text.LocalizedText)(nil),            // 27: google.type.LocalizedText
}
var file_google_maps_routing_v2_routes_service_proto_depIdxs = []int32{
	11, // 0: google.maps.routing.v2.ComputeRoutesRequest.origin:type_name -> google.maps.routing.v2.Waypoint
	11, // 1: google.maps.routing.v2.ComputeRoutesRequest.destination:type_name -> google.maps.routing.v2.Waypoint
	11, // 2: google.maps.routing.v2.ComputeRoutesRequest.intermediates:type_name -> google.maps.routing.v2.Waypoint
	12, // 3: google.maps.routing.v2.ComputeRoutesRequest.travel_mode:type_name -> google.maps.routing.v2.RouteTravelMode
	13, // 4: google.maps.routing.v2.ComputeRoutesRequest.routing_preference:type_name -> google.maps.routing.v2.RoutingPreference
	14, // 5: google.maps.routing.v2.ComputeRoutesRequest.polyline_quality:type_name -> google.maps.routing.v2.PolylineQuality
	15, // 6: google.maps.routing.v2.ComputeRoutesRequest.polyline_encoding:type_name -> google.maps.routing.v2.PolylineEncoding
	16, // 7: google.maps.routing.v2.ComputeRoutesRequest.departure_time:type_name -> google.protobuf.Timestamp
	16, // 8: google.maps.routing.v2.ComputeRoutesRequest.arrival_time:type_name -> google.protobuf.Timestamp
	17, // 9: google.maps.routing.v2.ComputeRoutesRequest.route_modifiers:type_name -> google.maps.routing.v2.RouteModifiers
	18, // 10: google.maps.routing.v2.ComputeRoutesRequest.units:type_name -> google.maps.routing.v2.Units
	1,  // 11: google.maps.routing.v2.ComputeRoutesRequest.requested_reference_routes:type_name -> google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute
	2,  // 12: google.maps.routing.v2.ComputeRoutesRequest.extra_computations:type_name -> google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation
	19, // 13: google.maps.routing.v2.ComputeRoutesRequest.traffic_model:type_name -> google.maps.routing.v2.TrafficModel
	20, // 14: google.maps.routing.v2.ComputeRoutesRequest.transit_preferences:type_name -> google.maps.routing.v2.TransitPreferences
	21, // 15: google.maps.routing.v2.ComputeRoutesResponse.routes:type_name -> google.maps.routing.v2.Route
	22, // 16: google.maps.routing.v2.ComputeRoutesResponse.fallback_info:type_name -> google.maps.routing.v2.FallbackInfo
	23, // 17: google.maps.routing.v2.ComputeRoutesResponse.geocoding_results:type_name -> google.maps.routing.v2.GeocodingResults
	7,  // 18: google.maps.routing.v2.ComputeRouteMatrixRequest.origins:type_name -> google.maps.routing.v2.RouteMatrixOrigin
	8,  // 19: google.maps.routing.v2.ComputeRouteMatrixRequest.destinations:type_name -> google.maps.routing.v2.RouteMatrixDestination
	12, // 20: google.maps.routing.v2.ComputeRouteMatrixRequest.travel_mode:type_name -> google.maps.routing.v2.RouteTravelMode
	13, // 21: google.maps.routing.v2.ComputeRouteMatrixRequest.routing_preference:type_name -> google.maps.routing.v2.RoutingPreference
	16, // 22: google.maps.routing.v2.ComputeRouteMatrixRequest.departure_time:type_name -> google.protobuf.Timestamp
	16, // 23: google.maps.routing.v2.ComputeRouteMatrixRequest.arrival_time:type_name -> google.protobuf.Timestamp
	18, // 24: google.maps.routing.v2.ComputeRouteMatrixRequest.units:type_name -> google.maps.routing.v2.Units
	3,  // 25: google.maps.routing.v2.ComputeRouteMatrixRequest.extra_computations:type_name -> google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation
	19, // 26: google.maps.routing.v2.ComputeRouteMatrixRequest.traffic_model:type_name -> google.maps.routing.v2.TrafficModel
	20, // 27: google.maps.routing.v2.ComputeRouteMatrixRequest.transit_preferences:type_name -> google.maps.routing.v2.TransitPreferences
	11, // 28: google.maps.routing.v2.RouteMatrixOrigin.waypoint:type_name -> google.maps.routing.v2.Waypoint
	17, // 29: google.maps.routing.v2.RouteMatrixOrigin.route_modifiers:type_name -> google.maps.routing.v2.RouteModifiers
	11, // 30: google.maps.routing.v2.RouteMatrixDestination.waypoint:type_name -> google.maps.routing.v2.Waypoint
	24, // 31: google.maps.routing.v2.RouteMatrixElement.status:type_name -> google.rpc.Status
	0,  // 32: google.maps.routing.v2.RouteMatrixElement.condition:type_name -> google.maps.routing.v2.RouteMatrixElementCondition
	25, // 33: google.maps.routing.v2.RouteMatrixElement.duration:type_name -> google.protobuf.Duration
	25, // 34: google.maps.routing.v2.RouteMatrixElement.static_duration:type_name -> google.protobuf.Duration
	26, // 35: google.maps.routing.v2.RouteMatrixElement.travel_advisory:type_name -> google.maps.routing.v2.RouteTravelAdvisory
	22, // 36: google.maps.routing.v2.RouteMatrixElement.fallback_info:type_name -> google.maps.routing.v2.FallbackInfo
	10, // 37: google.maps.routing.v2.RouteMatrixElement.localized_values:type_name -> google.maps.routing.v2.RouteMatrixElement.LocalizedValues
	27, // 38: google.maps.routing.v2.RouteMatrixElement.LocalizedValues.distance:type_name -> google.type.LocalizedText
	27, // 39: google.maps.routing.v2.RouteMatrixElement.LocalizedValues.duration:type_name -> google.type.LocalizedText
	27, // 40: google.maps.routing.v2.RouteMatrixElement.LocalizedValues.static_duration:type_name -> google.type.LocalizedText
	27, // 41: google.maps.routing.v2.RouteMatrixElement.LocalizedValues.transit_fare:type_name -> google.type.LocalizedText
	4,  // 42: google.maps.routing.v2.Routes.ComputeRoutes:input_type -> google.maps.routing.v2.ComputeRoutesRequest
	6,  // 43: google.maps.routing.v2.Routes.ComputeRouteMatrix:input_type -> google.maps.routing.v2.ComputeRouteMatrixRequest
	5,  // 44: google.maps.routing.v2.Routes.ComputeRoutes:output_type -> google.maps.routing.v2.ComputeRoutesResponse
	9,  // 45: google.maps.routing.v2.Routes.ComputeRouteMatrix:output_type -> google.maps.routing.v2.RouteMatrixElement
	44, // [44:46] is the sub-list for method output_type
	42, // [42:44] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_maps_routing_v2_routes_service_proto_init() }
func file_google_maps_routing_v2_routes_service_proto_init() {
	if File_google_maps_routing_v2_routes_service_proto != nil {
		return
	}
	file_google_maps_routing_v2_fallback_info_proto_init()
	file_google_maps_routing_v2_geocoding_results_proto_init()
	file_google_maps_routing_v2_polyline_proto_init()
	file_google_maps_routing_v2_route_proto_init()
	file_google_maps_routing_v2_route_modifiers_proto_init()
	file_google_maps_routing_v2_route_travel_mode_proto_init()
	file_google_maps_routing_v2_routing_preference_proto_init()
	file_google_maps_routing_v2_traffic_model_proto_init()
	file_google_maps_routing_v2_transit_preferences_proto_init()
	file_google_maps_routing_v2_units_proto_init()
	file_google_maps_routing_v2_waypoint_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_routing_v2_routes_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ComputeRoutesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_routes_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ComputeRoutesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_routes_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ComputeRouteMatrixRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_routes_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*RouteMatrixOrigin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_routes_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*RouteMatrixDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_routes_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*RouteMatrixElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routing_v2_routes_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*RouteMatrixElement_LocalizedValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_maps_routing_v2_routes_service_proto_msgTypes[5].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_routing_v2_routes_service_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_routing_v2_routes_service_proto_goTypes,
		DependencyIndexes: file_google_maps_routing_v2_routes_service_proto_depIdxs,
		EnumInfos:         file_google_maps_routing_v2_routes_service_proto_enumTypes,
		MessageInfos:      file_google_maps_routing_v2_routes_service_proto_msgTypes,
	}.Build()
	File_google_maps_routing_v2_routes_service_proto = out.File
	file_google_maps_routing_v2_routes_service_proto_rawDesc = nil
	file_google_maps_routing_v2_routes_service_proto_goTypes = nil
	file_google_maps_routing_v2_routes_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RoutesClient is the client API for Routes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RoutesClient interface {
	// Returns the primary route along with optional alternate routes, given a set
	// of terminal and intermediate waypoints.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using URL parameter
	// `$fields` or `fields`, or by using an HTTP/gRPC header `X-Goog-FieldMask`
	// (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)). The value
	// is a comma separated list of field paths. See detailed documentation about
	// [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of Route-level duration, distance, and polyline (an example
	//
	// production setup):
	//
	//	`X-Goog-FieldMask:
	//	routes.duration,routes.distanceMeters,routes.polyline.encodedPolyline`
	//
	// Google discourage the use of the wildcard (`*`) response field mask, or
	// specifying the field mask at the top level (`routes`), because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need
	// in your production job ensures stable latency performance. We might add
	// more response fields in the future, and those new fields might require
	// extra computation time. If you select all fields, or if you select all
	// fields at the top level, then you might experience performance degradation
	// because any new field we add will be automatically included in the
	// response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRoutes(ctx context.Context, in *ComputeRoutesRequest, opts ...grpc.CallOption) (*ComputeRoutesResponse, error)
	// Takes in a list of origins and destinations and returns a stream containing
	// route information for each combination of origin and destination.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using the URL
	// parameter `$fields` or `fields`, or by using the HTTP/gRPC header
	// `X-Goog-FieldMask` (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)).
	// The value is a comma separated list of field paths. See this detailed
	// documentation about [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of route durations, distances, element status, condition, and
	//     element indices (an example production setup):
	//     `X-Goog-FieldMask:
	//     originIndex,destinationIndex,status,condition,distanceMeters,duration`
	//
	// It is critical that you include `status` in your field mask as otherwise
	// all messages will appear to be OK. Google discourages the use of the
	// wildcard (`*`) response field mask, because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need in your production job ensures
	// stable latency performance. We might add more response fields in the
	// future, and those new fields might require extra computation time. If you
	// select all fields, or if you select all fields at the top level, then you
	// might experience performance degradation because any new field we add will
	// be automatically included in the response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRouteMatrix(ctx context.Context, in *ComputeRouteMatrixRequest, opts ...grpc.CallOption) (Routes_ComputeRouteMatrixClient, error)
}

type routesClient struct {
	cc grpc.ClientConnInterface
}

func NewRoutesClient(cc grpc.ClientConnInterface) RoutesClient {
	return &routesClient{cc}
}

func (c *routesClient) ComputeRoutes(ctx context.Context, in *ComputeRoutesRequest, opts ...grpc.CallOption) (*ComputeRoutesResponse, error) {
	out := new(ComputeRoutesResponse)
	err := c.cc.Invoke(ctx, "/google.maps.routing.v2.Routes/ComputeRoutes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routesClient) ComputeRouteMatrix(ctx context.Context, in *ComputeRouteMatrixRequest, opts ...grpc.CallOption) (Routes_ComputeRouteMatrixClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Routes_serviceDesc.Streams[0], "/google.maps.routing.v2.Routes/ComputeRouteMatrix", opts...)
	if err != nil {
		return nil, err
	}
	x := &routesComputeRouteMatrixClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Routes_ComputeRouteMatrixClient interface {
	Recv() (*RouteMatrixElement, error)
	grpc.ClientStream
}

type routesComputeRouteMatrixClient struct {
	grpc.ClientStream
}

func (x *routesComputeRouteMatrixClient) Recv() (*RouteMatrixElement, error) {
	m := new(RouteMatrixElement)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// RoutesServer is the server API for Routes service.
type RoutesServer interface {
	// Returns the primary route along with optional alternate routes, given a set
	// of terminal and intermediate waypoints.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using URL parameter
	// `$fields` or `fields`, or by using an HTTP/gRPC header `X-Goog-FieldMask`
	// (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)). The value
	// is a comma separated list of field paths. See detailed documentation about
	// [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of Route-level duration, distance, and polyline (an example
	//
	// production setup):
	//
	//	`X-Goog-FieldMask:
	//	routes.duration,routes.distanceMeters,routes.polyline.encodedPolyline`
	//
	// Google discourage the use of the wildcard (`*`) response field mask, or
	// specifying the field mask at the top level (`routes`), because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need
	// in your production job ensures stable latency performance. We might add
	// more response fields in the future, and those new fields might require
	// extra computation time. If you select all fields, or if you select all
	// fields at the top level, then you might experience performance degradation
	// because any new field we add will be automatically included in the
	// response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRoutes(context.Context, *ComputeRoutesRequest) (*ComputeRoutesResponse, error)
	// Takes in a list of origins and destinations and returns a stream containing
	// route information for each combination of origin and destination.
	//
	// **NOTE:** This method requires that you specify a response field mask in
	// the input. You can provide the response field mask by using the URL
	// parameter `$fields` or `fields`, or by using the HTTP/gRPC header
	// `X-Goog-FieldMask` (see the [available URL parameters and
	// headers](https://cloud.google.com/apis/docs/system-parameters)).
	// The value is a comma separated list of field paths. See this detailed
	// documentation about [how to construct the field
	// paths](https://github.com/protocolbuffers/protobuf/blob/master/src/google/protobuf/field_mask.proto).
	//
	// For example, in this method:
	//
	//   - Field mask of all available fields (for manual inspection):
	//     `X-Goog-FieldMask: *`
	//   - Field mask of route durations, distances, element status, condition, and
	//     element indices (an example production setup):
	//     `X-Goog-FieldMask:
	//     originIndex,destinationIndex,status,condition,distanceMeters,duration`
	//
	// It is critical that you include `status` in your field mask as otherwise
	// all messages will appear to be OK. Google discourages the use of the
	// wildcard (`*`) response field mask, because:
	//
	// * Selecting only the fields that you need helps our server save computation
	// cycles, allowing us to return the result to you with a lower latency.
	// * Selecting only the fields that you need in your production job ensures
	// stable latency performance. We might add more response fields in the
	// future, and those new fields might require extra computation time. If you
	// select all fields, or if you select all fields at the top level, then you
	// might experience performance degradation because any new field we add will
	// be automatically included in the response.
	// * Selecting only the fields that you need results in a smaller response
	// size, and thus higher network throughput.
	ComputeRouteMatrix(*ComputeRouteMatrixRequest, Routes_ComputeRouteMatrixServer) error
}

// UnimplementedRoutesServer can be embedded to have forward compatible implementations.
type UnimplementedRoutesServer struct {
}

func (*UnimplementedRoutesServer) ComputeRoutes(context.Context, *ComputeRoutesRequest) (*ComputeRoutesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ComputeRoutes not implemented")
}
func (*UnimplementedRoutesServer) ComputeRouteMatrix(*ComputeRouteMatrixRequest, Routes_ComputeRouteMatrixServer) error {
	return status1.Errorf(codes.Unimplemented, "method ComputeRouteMatrix not implemented")
}

func RegisterRoutesServer(s *grpc.Server, srv RoutesServer) {
	s.RegisterService(&_Routes_serviceDesc, srv)
}

func _Routes_ComputeRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoutesServer).ComputeRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.routing.v2.Routes/ComputeRoutes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoutesServer).ComputeRoutes(ctx, req.(*ComputeRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Routes_ComputeRouteMatrix_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ComputeRouteMatrixRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RoutesServer).ComputeRouteMatrix(m, &routesComputeRouteMatrixServer{stream})
}

type Routes_ComputeRouteMatrixServer interface {
	Send(*RouteMatrixElement) error
	grpc.ServerStream
}

type routesComputeRouteMatrixServer struct {
	grpc.ServerStream
}

func (x *routesComputeRouteMatrixServer) Send(m *RouteMatrixElement) error {
	return x.ServerStream.SendMsg(m)
}

var _Routes_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.routing.v2.Routes",
	HandlerType: (*RoutesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeRoutes",
			Handler:    _Routes_ComputeRoutes_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ComputeRouteMatrix",
			Handler:       _Routes_ComputeRouteMatrix_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/maps/routing/v2/routes_service.proto",
}
