// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/channel/v1/reports_service.proto

package channelpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	date "google.golang.org/genproto/googleapis/type/date"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	decimal "google.golang.org/genproto/googleapis/type/decimal"
	money "google.golang.org/genproto/googleapis/type/money"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Available data types for columns. Corresponds to the fields in the
// ReportValue `oneof` field.
type Column_DataType int32

const (
	// Not used.
	Column_DATA_TYPE_UNSPECIFIED Column_DataType = 0
	// ReportValues for this column will use string_value.
	Column_STRING Column_DataType = 1
	// ReportValues for this column will use int_value.
	Column_INT Column_DataType = 2
	// ReportValues for this column will use decimal_value.
	Column_DECIMAL Column_DataType = 3
	// ReportValues for this column will use money_value.
	Column_MONEY Column_DataType = 4
	// ReportValues for this column will use date_value.
	Column_DATE Column_DataType = 5
	// ReportValues for this column will use date_time_value.
	Column_DATE_TIME Column_DataType = 6
)

// Enum value maps for Column_DataType.
var (
	Column_DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "STRING",
		2: "INT",
		3: "DECIMAL",
		4: "MONEY",
		5: "DATE",
		6: "DATE_TIME",
	}
	Column_DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"STRING":                1,
		"INT":                   2,
		"DECIMAL":               3,
		"MONEY":                 4,
		"DATE":                  5,
		"DATE_TIME":             6,
	}
)

func (x Column_DataType) Enum() *Column_DataType {
	p := new(Column_DataType)
	*p = x
	return p
}

func (x Column_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Column_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_reports_service_proto_enumTypes[0].Descriptor()
}

func (Column_DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_reports_service_proto_enumTypes[0]
}

func (x Column_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Column_DataType.Descriptor instead.
func (Column_DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{8, 0}
}

// Available states of report generation.
type ReportStatus_State int32

const (
	// Not used.
	ReportStatus_STATE_UNSPECIFIED ReportStatus_State = 0
	// Report processing started.
	ReportStatus_STARTED ReportStatus_State = 1
	// Data generated from the report is being staged.
	ReportStatus_WRITING ReportStatus_State = 2
	// Report data is available for access.
	ReportStatus_AVAILABLE ReportStatus_State = 3
	// Report failed.
	ReportStatus_FAILED ReportStatus_State = 4
)

// Enum value maps for ReportStatus_State.
var (
	ReportStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "WRITING",
		3: "AVAILABLE",
		4: "FAILED",
	}
	ReportStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           1,
		"WRITING":           2,
		"AVAILABLE":         3,
		"FAILED":            4,
	}
)

func (x ReportStatus_State) Enum() *ReportStatus_State {
	p := new(ReportStatus_State)
	*p = x
	return p
}

func (x ReportStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReportStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_reports_service_proto_enumTypes[1].Descriptor()
}

func (ReportStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_reports_service_proto_enumTypes[1]
}

func (x ReportStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReportStatus_State.Descriptor instead.
func (ReportStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{12, 0}
}

// Request message for [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
type RunReportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The report's resource name. Specifies the account and report used to
	// generate report data. The report_id identifier is a UID (for example,
	// `613bf59q`).
	// Name uses the format:
	// accounts/{account_id}/reports/{report_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The range of usage or invoice dates to include in the result.
	DateRange *DateRange `protobuf:"bytes,2,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// Optional. A structured string that defines conditions on dimension columns to
	// restrict the report output.
	//
	// Filters support logical operators (AND, OR, NOT) and conditional operators
	// (=, !=, <, >, <=, and >=) using `column_id` as keys.
	//
	// For example:
	// `(customer:"accounts/C123abc/customers/S456def" OR
	// customer:"accounts/C123abc/customers/S789ghi") AND
	// invoice_start_date.year >= 2022`
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US".  If specified, the
	// response is localized to the corresponding language code if the
	// original data sources support it.
	// Default is "en-US".
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *RunReportJobRequest) Reset() {
	*x = RunReportJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunReportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunReportJobRequest) ProtoMessage() {}

func (x *RunReportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunReportJobRequest.ProtoReflect.Descriptor instead.
func (*RunReportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{0}
}

func (x *RunReportJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RunReportJobRequest) GetDateRange() *DateRange {
	if x != nil {
		return x.DateRange
	}
	return nil
}

func (x *RunReportJobRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *RunReportJobRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
type RunReportJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pass `report_job.name` to [FetchReportResultsRequest.report_job][google.cloud.channel.v1.FetchReportResultsRequest.report_job]
	// to retrieve the report's results.
	ReportJob *ReportJob `protobuf:"bytes,1,opt,name=report_job,json=reportJob,proto3" json:"report_job,omitempty"`
	// The metadata for the report's results (display name, columns, row count,
	// and date range). If you view this before the operation finishes,
	// you may see incomplete data.
	ReportMetadata *ReportResultsMetadata `protobuf:"bytes,2,opt,name=report_metadata,json=reportMetadata,proto3" json:"report_metadata,omitempty"`
}

func (x *RunReportJobResponse) Reset() {
	*x = RunReportJobResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunReportJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunReportJobResponse) ProtoMessage() {}

func (x *RunReportJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunReportJobResponse.ProtoReflect.Descriptor instead.
func (*RunReportJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{1}
}

func (x *RunReportJobResponse) GetReportJob() *ReportJob {
	if x != nil {
		return x.ReportJob
	}
	return nil
}

func (x *RunReportJobResponse) GetReportMetadata() *ReportResultsMetadata {
	if x != nil {
		return x.ReportMetadata
	}
	return nil
}

// Request message for [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults].
type FetchReportResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The report job created by [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
	// Report_job uses the format:
	// accounts/{account_id}/reportJobs/{report_job_id}
	ReportJob string `protobuf:"bytes,1,opt,name=report_job,json=reportJob,proto3" json:"report_job,omitempty"`
	// Optional. Requested page size of the report. The server may return fewer results than
	// requested. If you don't specify a page size, the server uses a sensible
	// default (may change over time).
	//
	// The maximum value is 30,000; the server will change larger values to
	// 30,000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token that specifies a page of results beyond the first page.
	// Obtained through
	// [FetchReportResultsResponse.next_page_token][google.cloud.channel.v1.FetchReportResultsResponse.next_page_token] of the previous
	// [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchReportResultsRequest) Reset() {
	*x = FetchReportResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchReportResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReportResultsRequest) ProtoMessage() {}

func (x *FetchReportResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReportResultsRequest.ProtoReflect.Descriptor instead.
func (*FetchReportResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{2}
}

func (x *FetchReportResultsRequest) GetReportJob() string {
	if x != nil {
		return x.ReportJob
	}
	return ""
}

func (x *FetchReportResultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchReportResultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults].
// Contains a tabular representation of the report results.
type FetchReportResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata for the report results (display name, columns, row count, and
	// date ranges).
	ReportMetadata *ReportResultsMetadata `protobuf:"bytes,1,opt,name=report_metadata,json=reportMetadata,proto3" json:"report_metadata,omitempty"`
	// The report's lists of values. Each row follows the settings and ordering
	// of the columns from `report_metadata`.
	Rows []*Row `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
	// Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
	// the next page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchReportResultsResponse) Reset() {
	*x = FetchReportResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchReportResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReportResultsResponse) ProtoMessage() {}

func (x *FetchReportResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReportResultsResponse.ProtoReflect.Descriptor instead.
func (*FetchReportResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{3}
}

func (x *FetchReportResultsResponse) GetReportMetadata() *ReportResultsMetadata {
	if x != nil {
		return x.ReportMetadata
	}
	return nil
}

func (x *FetchReportResultsResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *FetchReportResultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
type ListReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the partner account to list available reports for.
	// Parent uses the format:
	// accounts/{account_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size of the report. The server might return fewer results
	// than requested. If unspecified, returns 20 reports.
	// The maximum value is 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token that specifies a page of results beyond the first page.
	// Obtained through
	// [ListReportsResponse.next_page_token][google.cloud.channel.v1.ListReportsResponse.next_page_token] of the previous
	// [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US".  If specified, the
	// response is localized to the corresponding language code if the
	// original data sources support it.
	// Default is "en-US".
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListReportsRequest) Reset() {
	*x = ListReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportsRequest) ProtoMessage() {}

func (x *ListReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportsRequest.ProtoReflect.Descriptor instead.
func (*ListReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListReportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReportsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
type ListReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reports available to the partner.
	Reports []*Report `protobuf:"bytes,1,rep,name=reports,proto3" json:"reports,omitempty"`
	// Pass this token to [FetchReportResultsRequest.page_token][google.cloud.channel.v1.FetchReportResultsRequest.page_token] to retrieve
	// the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReportsResponse) Reset() {
	*x = ListReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportsResponse) ProtoMessage() {}

func (x *ListReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportsResponse.ProtoReflect.Descriptor instead.
func (*ListReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListReportsResponse) GetReports() []*Report {
	if x != nil {
		return x.Reports
	}
	return nil
}

func (x *ListReportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The result of a [RunReportJob][] operation. Contains the name to use in
// [FetchReportResultsRequest.report_job][google.cloud.channel.v1.FetchReportResultsRequest.report_job] and the status of the operation.
type ReportJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of a report job.
	// Name uses the format:
	// `accounts/{account_id}/reportJobs/{report_job_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current status of report generation.
	ReportStatus *ReportStatus `protobuf:"bytes,2,opt,name=report_status,json=reportStatus,proto3" json:"report_status,omitempty"`
}

func (x *ReportJob) Reset() {
	*x = ReportJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportJob) ProtoMessage() {}

func (x *ReportJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportJob.ProtoReflect.Descriptor instead.
func (*ReportJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{6}
}

func (x *ReportJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReportJob) GetReportStatus() *ReportStatus {
	if x != nil {
		return x.ReportStatus
	}
	return nil
}

// The features describing the data. Returned by
// [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob] and
// [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults].
type ReportResultsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the completed report.
	Report *Report `protobuf:"bytes,1,opt,name=report,proto3" json:"report,omitempty"`
	// The total number of rows of data in the final report.
	RowCount int64 `protobuf:"varint,2,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// The date range of reported usage.
	DateRange *DateRange `protobuf:"bytes,3,opt,name=date_range,json=dateRange,proto3" json:"date_range,omitempty"`
	// The usage dates immediately preceding `date_range` with the same duration.
	// Use this to calculate trending usage and costs. This is only populated if
	// you request trending data.
	//
	// For example, if `date_range` is July 1-15, `preceding_date_range` will be
	// June 16-30.
	PrecedingDateRange *DateRange `protobuf:"bytes,4,opt,name=preceding_date_range,json=precedingDateRange,proto3" json:"preceding_date_range,omitempty"`
}

func (x *ReportResultsMetadata) Reset() {
	*x = ReportResultsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportResultsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportResultsMetadata) ProtoMessage() {}

func (x *ReportResultsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportResultsMetadata.ProtoReflect.Descriptor instead.
func (*ReportResultsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{7}
}

func (x *ReportResultsMetadata) GetReport() *Report {
	if x != nil {
		return x.Report
	}
	return nil
}

func (x *ReportResultsMetadata) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *ReportResultsMetadata) GetDateRange() *DateRange {
	if x != nil {
		return x.DateRange
	}
	return nil
}

func (x *ReportResultsMetadata) GetPrecedingDateRange() *DateRange {
	if x != nil {
		return x.PrecedingDateRange
	}
	return nil
}

// The definition of a report column. Specifies the data properties
// in the corresponding position of the report rows.
type Column struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the column (for example, customer_domain,
	// channel_partner, customer_cost). You can use column IDs in
	// [RunReportJobRequest.filter][google.cloud.channel.v1.RunReportJobRequest.filter].
	// To see all reports and their columns, call
	// [CloudChannelReportsService.ListReports][google.cloud.channel.v1.CloudChannelReportsService.ListReports].
	ColumnId string `protobuf:"bytes,1,opt,name=column_id,json=columnId,proto3" json:"column_id,omitempty"`
	// The column's display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of the values for this column.
	DataType Column_DataType `protobuf:"varint,3,opt,name=data_type,json=dataType,proto3,enum=google.cloud.channel.v1.Column_DataType" json:"data_type,omitempty"`
}

func (x *Column) Reset() {
	*x = Column{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Column) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Column) ProtoMessage() {}

func (x *Column) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Column.ProtoReflect.Descriptor instead.
func (*Column) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{8}
}

func (x *Column) GetColumnId() string {
	if x != nil {
		return x.ColumnId
	}
	return ""
}

func (x *Column) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Column) GetDataType() Column_DataType {
	if x != nil {
		return x.DataType
	}
	return Column_DATA_TYPE_UNSPECIFIED
}

// A representation of usage or invoice date ranges.
type DateRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The earliest usage date time (inclusive).
	//
	// If you use time groupings (daily, weekly, etc), each group uses
	// midnight to midnight (Pacific time). The usage start date is
	// rounded down to include all usage from the specified date. We recommend
	// that clients pass `usage_start_date_time` in Pacific time.
	UsageStartDateTime *datetime.DateTime `protobuf:"bytes,1,opt,name=usage_start_date_time,json=usageStartDateTime,proto3" json:"usage_start_date_time,omitempty"`
	// The latest usage date time (exclusive).
	//
	// If you use time groupings (daily, weekly, etc), each group uses
	// midnight to midnight (Pacific time). The usage end date is
	// rounded down to include all usage from the specified date. We recommend
	// that clients pass `usage_start_date_time` in Pacific time.
	UsageEndDateTime *datetime.DateTime `protobuf:"bytes,2,opt,name=usage_end_date_time,json=usageEndDateTime,proto3" json:"usage_end_date_time,omitempty"`
	// The earliest invoice date (inclusive).
	//
	// If your product uses monthly invoices, and this value is not the beginning
	// of a month, this will adjust the date to the first day of the given month.
	InvoiceStartDate *date.Date `protobuf:"bytes,3,opt,name=invoice_start_date,json=invoiceStartDate,proto3" json:"invoice_start_date,omitempty"`
	// The latest invoice date (exclusive).
	//
	// If your product uses monthly invoices, and this value is not the beginning
	// of a month, this will adjust the date to the first day of the following
	// month.
	InvoiceEndDate *date.Date `protobuf:"bytes,4,opt,name=invoice_end_date,json=invoiceEndDate,proto3" json:"invoice_end_date,omitempty"`
}

func (x *DateRange) Reset() {
	*x = DateRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateRange) ProtoMessage() {}

func (x *DateRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateRange.ProtoReflect.Descriptor instead.
func (*DateRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{9}
}

func (x *DateRange) GetUsageStartDateTime() *datetime.DateTime {
	if x != nil {
		return x.UsageStartDateTime
	}
	return nil
}

func (x *DateRange) GetUsageEndDateTime() *datetime.DateTime {
	if x != nil {
		return x.UsageEndDateTime
	}
	return nil
}

func (x *DateRange) GetInvoiceStartDate() *date.Date {
	if x != nil {
		return x.InvoiceStartDate
	}
	return nil
}

func (x *DateRange) GetInvoiceEndDate() *date.Date {
	if x != nil {
		return x.InvoiceEndDate
	}
	return nil
}

// A row of report values.
type Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of values in the row.
	Values []*ReportValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Row) Reset() {
	*x = Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Row) ProtoMessage() {}

func (x *Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Row.ProtoReflect.Descriptor instead.
func (*Row) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{10}
}

func (x *Row) GetValues() []*ReportValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// A single report value.
type ReportValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A single report value.
	//
	// Types that are assignable to Value:
	//
	//	*ReportValue_StringValue
	//	*ReportValue_IntValue
	//	*ReportValue_DecimalValue
	//	*ReportValue_MoneyValue
	//	*ReportValue_DateValue
	//	*ReportValue_DateTimeValue
	Value isReportValue_Value `protobuf_oneof:"value"`
}

func (x *ReportValue) Reset() {
	*x = ReportValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportValue) ProtoMessage() {}

func (x *ReportValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportValue.ProtoReflect.Descriptor instead.
func (*ReportValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{11}
}

func (m *ReportValue) GetValue() isReportValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *ReportValue) GetStringValue() string {
	if x, ok := x.GetValue().(*ReportValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *ReportValue) GetIntValue() int64 {
	if x, ok := x.GetValue().(*ReportValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *ReportValue) GetDecimalValue() *decimal.Decimal {
	if x, ok := x.GetValue().(*ReportValue_DecimalValue); ok {
		return x.DecimalValue
	}
	return nil
}

func (x *ReportValue) GetMoneyValue() *money.Money {
	if x, ok := x.GetValue().(*ReportValue_MoneyValue); ok {
		return x.MoneyValue
	}
	return nil
}

func (x *ReportValue) GetDateValue() *date.Date {
	if x, ok := x.GetValue().(*ReportValue_DateValue); ok {
		return x.DateValue
	}
	return nil
}

func (x *ReportValue) GetDateTimeValue() *datetime.DateTime {
	if x, ok := x.GetValue().(*ReportValue_DateTimeValue); ok {
		return x.DateTimeValue
	}
	return nil
}

type isReportValue_Value interface {
	isReportValue_Value()
}

type ReportValue_StringValue struct {
	// A value of type `string`.
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type ReportValue_IntValue struct {
	// A value of type `int`.
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type ReportValue_DecimalValue struct {
	// A value of type `google.type.Decimal`, representing non-integer numeric
	// values.
	DecimalValue *decimal.Decimal `protobuf:"bytes,3,opt,name=decimal_value,json=decimalValue,proto3,oneof"`
}

type ReportValue_MoneyValue struct {
	// A value of type `google.type.Money` (currency code, whole units, decimal
	// units).
	MoneyValue *money.Money `protobuf:"bytes,4,opt,name=money_value,json=moneyValue,proto3,oneof"`
}

type ReportValue_DateValue struct {
	// A value of type `google.type.Date` (year, month, day).
	DateValue *date.Date `protobuf:"bytes,5,opt,name=date_value,json=dateValue,proto3,oneof"`
}

type ReportValue_DateTimeValue struct {
	// A value of type `google.type.DateTime` (year, month, day, hour, minute,
	// second, and UTC offset or timezone.)
	DateTimeValue *datetime.DateTime `protobuf:"bytes,6,opt,name=date_time_value,json=dateTimeValue,proto3,oneof"`
}

func (*ReportValue_StringValue) isReportValue_Value() {}

func (*ReportValue_IntValue) isReportValue_Value() {}

func (*ReportValue_DecimalValue) isReportValue_Value() {}

func (*ReportValue_MoneyValue) isReportValue_Value() {}

func (*ReportValue_DateValue) isReportValue_Value() {}

func (*ReportValue_DateTimeValue) isReportValue_Value() {}

// Status of a report generation process.
type ReportStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current state of the report generation process.
	State ReportStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.channel.v1.ReportStatus_State" json:"state,omitempty"`
	// The report generation's start time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The report generation's completion time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ReportStatus) Reset() {
	*x = ReportStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportStatus) ProtoMessage() {}

func (x *ReportStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportStatus.ProtoReflect.Descriptor instead.
func (*ReportStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{12}
}

func (x *ReportStatus) GetState() ReportStatus_State {
	if x != nil {
		return x.State
	}
	return ReportStatus_STATE_UNSPECIFIED
}

func (x *ReportStatus) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ReportStatus) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The ID and description of a report that was used to generate report data.
// For example, "GCP Daily Spend", "Google Workspace License Activity", etc.
type Report struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The report's resource name. Specifies the account and report used to
	// generate report data. The report_id identifier is a UID
	// (for example, `613bf59q`).
	//
	// Name uses the format:
	// accounts/{account_id}/reports/{report_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A human-readable name for this report.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The list of columns included in the report. This defines the schema of
	// the report results.
	Columns []*Column `protobuf:"bytes,3,rep,name=columns,proto3" json:"columns,omitempty"`
	// A description of other aspects of the report, such as the products
	// it supports.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Report) Reset() {
	*x = Report{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Report) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Report) ProtoMessage() {}

func (x *Report) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_reports_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Report.ProtoReflect.Descriptor instead.
func (*Report) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP(), []int{13}
}

func (x *Report) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Report) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Report) GetColumns() []*Column {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *Report) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

var File_google_cloud_channel_v1_reports_service_proto protoreflect.FileDescriptor

var file_google_cloud_channel_v1_reports_service_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f,
	0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe4, 0x01, 0x0a, 0x13, 0x52, 0x75,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x46, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x22, 0xb2, 0x01, 0x0a, 0x14, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x0a, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x52, 0x09, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x57, 0x0a, 0x0f,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xaf, 0x01, 0x0a, 0x19, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x09, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcf, 0x01, 0x0a, 0x1a, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x30, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x78, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x07, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc8, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x3a, 0x56, 0xea, 0x41, 0x53, 0x0a,
	0x25, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x2a, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f,
	0x62, 0x7d, 0x22, 0x86, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x37, 0x0a, 0x06,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x41, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x54, 0x0a, 0x14, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x12, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69,
	0x6e, 0x67, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xfc, 0x01, 0x0a, 0x06,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x22, 0x6b, 0x0a,
	0x08, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x43,
	0x49, 0x4d, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x45, 0x59, 0x10,
	0x04, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x45, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x44,
	0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x06, 0x22, 0x99, 0x02, 0x0a, 0x09, 0x44,
	0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x48, 0x0a, 0x15, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x12,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x44, 0x0a, 0x13, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x10, 0x75, 0x73, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x64,
	0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x12, 0x69, 0x6e, 0x76, 0x6f,
	0x69, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x10, 0x69, 0x6e, 0x76,
	0x6f, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x45,
	0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x22, 0x43, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x3c, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xc3, 0x02, 0x0a, 0x0b,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x3b, 0x0a, 0x0d, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x0c,
	0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x35, 0x0a, 0x0b,
	0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64, 0x61,
	0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3f, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x98, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x52, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0xef, 0x01, 0x0a,
	0x06, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x4c, 0xea, 0x41, 0x49, 0x0a, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x23, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x7d, 0x32, 0xa6,
	0x05, 0x0a, 0x1a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb7, 0x01,
	0x0a, 0x0c, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x28, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x29, 0x0a, 0x14,
	0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd2, 0x01, 0x0a, 0x12, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22,
	0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x12, 0x9a, 0x01, 0x0a,
	0x0b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x21, 0x12,
	0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x1a, 0x5c, 0xca, 0x41, 0x1b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x3b, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x75, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x72,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x74, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_channel_v1_reports_service_proto_rawDescOnce sync.Once
	file_google_cloud_channel_v1_reports_service_proto_rawDescData = file_google_cloud_channel_v1_reports_service_proto_rawDesc
)

func file_google_cloud_channel_v1_reports_service_proto_rawDescGZIP() []byte {
	file_google_cloud_channel_v1_reports_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_channel_v1_reports_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_channel_v1_reports_service_proto_rawDescData)
	})
	return file_google_cloud_channel_v1_reports_service_proto_rawDescData
}

var file_google_cloud_channel_v1_reports_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_channel_v1_reports_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_channel_v1_reports_service_proto_goTypes = []interface{}{
	(Column_DataType)(0),               // 0: google.cloud.channel.v1.Column.DataType
	(ReportStatus_State)(0),            // 1: google.cloud.channel.v1.ReportStatus.State
	(*RunReportJobRequest)(nil),        // 2: google.cloud.channel.v1.RunReportJobRequest
	(*RunReportJobResponse)(nil),       // 3: google.cloud.channel.v1.RunReportJobResponse
	(*FetchReportResultsRequest)(nil),  // 4: google.cloud.channel.v1.FetchReportResultsRequest
	(*FetchReportResultsResponse)(nil), // 5: google.cloud.channel.v1.FetchReportResultsResponse
	(*ListReportsRequest)(nil),         // 6: google.cloud.channel.v1.ListReportsRequest
	(*ListReportsResponse)(nil),        // 7: google.cloud.channel.v1.ListReportsResponse
	(*ReportJob)(nil),                  // 8: google.cloud.channel.v1.ReportJob
	(*ReportResultsMetadata)(nil),      // 9: google.cloud.channel.v1.ReportResultsMetadata
	(*Column)(nil),                     // 10: google.cloud.channel.v1.Column
	(*DateRange)(nil),                  // 11: google.cloud.channel.v1.DateRange
	(*Row)(nil),                        // 12: google.cloud.channel.v1.Row
	(*ReportValue)(nil),                // 13: google.cloud.channel.v1.ReportValue
	(*ReportStatus)(nil),               // 14: google.cloud.channel.v1.ReportStatus
	(*Report)(nil),                     // 15: google.cloud.channel.v1.Report
	(*datetime.DateTime)(nil),          // 16: google.type.DateTime
	(*date.Date)(nil),                  // 17: google.type.Date
	(*decimal.Decimal)(nil),            // 18: google.type.Decimal
	(*money.Money)(nil),                // 19: google.type.Money
	(*timestamppb.Timestamp)(nil),      // 20: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),      // 21: google.longrunning.Operation
}
var file_google_cloud_channel_v1_reports_service_proto_depIdxs = []int32{
	11, // 0: google.cloud.channel.v1.RunReportJobRequest.date_range:type_name -> google.cloud.channel.v1.DateRange
	8,  // 1: google.cloud.channel.v1.RunReportJobResponse.report_job:type_name -> google.cloud.channel.v1.ReportJob
	9,  // 2: google.cloud.channel.v1.RunReportJobResponse.report_metadata:type_name -> google.cloud.channel.v1.ReportResultsMetadata
	9,  // 3: google.cloud.channel.v1.FetchReportResultsResponse.report_metadata:type_name -> google.cloud.channel.v1.ReportResultsMetadata
	12, // 4: google.cloud.channel.v1.FetchReportResultsResponse.rows:type_name -> google.cloud.channel.v1.Row
	15, // 5: google.cloud.channel.v1.ListReportsResponse.reports:type_name -> google.cloud.channel.v1.Report
	14, // 6: google.cloud.channel.v1.ReportJob.report_status:type_name -> google.cloud.channel.v1.ReportStatus
	15, // 7: google.cloud.channel.v1.ReportResultsMetadata.report:type_name -> google.cloud.channel.v1.Report
	11, // 8: google.cloud.channel.v1.ReportResultsMetadata.date_range:type_name -> google.cloud.channel.v1.DateRange
	11, // 9: google.cloud.channel.v1.ReportResultsMetadata.preceding_date_range:type_name -> google.cloud.channel.v1.DateRange
	0,  // 10: google.cloud.channel.v1.Column.data_type:type_name -> google.cloud.channel.v1.Column.DataType
	16, // 11: google.cloud.channel.v1.DateRange.usage_start_date_time:type_name -> google.type.DateTime
	16, // 12: google.cloud.channel.v1.DateRange.usage_end_date_time:type_name -> google.type.DateTime
	17, // 13: google.cloud.channel.v1.DateRange.invoice_start_date:type_name -> google.type.Date
	17, // 14: google.cloud.channel.v1.DateRange.invoice_end_date:type_name -> google.type.Date
	13, // 15: google.cloud.channel.v1.Row.values:type_name -> google.cloud.channel.v1.ReportValue
	18, // 16: google.cloud.channel.v1.ReportValue.decimal_value:type_name -> google.type.Decimal
	19, // 17: google.cloud.channel.v1.ReportValue.money_value:type_name -> google.type.Money
	17, // 18: google.cloud.channel.v1.ReportValue.date_value:type_name -> google.type.Date
	16, // 19: google.cloud.channel.v1.ReportValue.date_time_value:type_name -> google.type.DateTime
	1,  // 20: google.cloud.channel.v1.ReportStatus.state:type_name -> google.cloud.channel.v1.ReportStatus.State
	20, // 21: google.cloud.channel.v1.ReportStatus.start_time:type_name -> google.protobuf.Timestamp
	20, // 22: google.cloud.channel.v1.ReportStatus.end_time:type_name -> google.protobuf.Timestamp
	10, // 23: google.cloud.channel.v1.Report.columns:type_name -> google.cloud.channel.v1.Column
	2,  // 24: google.cloud.channel.v1.CloudChannelReportsService.RunReportJob:input_type -> google.cloud.channel.v1.RunReportJobRequest
	4,  // 25: google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults:input_type -> google.cloud.channel.v1.FetchReportResultsRequest
	6,  // 26: google.cloud.channel.v1.CloudChannelReportsService.ListReports:input_type -> google.cloud.channel.v1.ListReportsRequest
	21, // 27: google.cloud.channel.v1.CloudChannelReportsService.RunReportJob:output_type -> google.longrunning.Operation
	5,  // 28: google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults:output_type -> google.cloud.channel.v1.FetchReportResultsResponse
	7,  // 29: google.cloud.channel.v1.CloudChannelReportsService.ListReports:output_type -> google.cloud.channel.v1.ListReportsResponse
	27, // [27:30] is the sub-list for method output_type
	24, // [24:27] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_channel_v1_reports_service_proto_init() }
func file_google_cloud_channel_v1_reports_service_proto_init() {
	if File_google_cloud_channel_v1_reports_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunReportJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunReportJobResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchReportResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchReportResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportResultsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Column); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_reports_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Report); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_channel_v1_reports_service_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*ReportValue_StringValue)(nil),
		(*ReportValue_IntValue)(nil),
		(*ReportValue_DecimalValue)(nil),
		(*ReportValue_MoneyValue)(nil),
		(*ReportValue_DateValue)(nil),
		(*ReportValue_DateTimeValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_channel_v1_reports_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_channel_v1_reports_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_channel_v1_reports_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_channel_v1_reports_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_channel_v1_reports_service_proto_msgTypes,
	}.Build()
	File_google_cloud_channel_v1_reports_service_proto = out.File
	file_google_cloud_channel_v1_reports_service_proto_rawDesc = nil
	file_google_cloud_channel_v1_reports_service_proto_goTypes = nil
	file_google_cloud_channel_v1_reports_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudChannelReportsServiceClient is the client API for CloudChannelReportsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudChannelReportsServiceClient interface {
	// Begins generation of data for a given report. The report
	// identifier is a UID (for example, `613bf59q`).
	//
	// Possible error codes:
	//
	//   - PERMISSION_DENIED: The user doesn't have access to this report.
	//   - INVALID_ARGUMENT: Required request parameters are missing
	//     or invalid.
	//   - NOT_FOUND: The report identifier was not found.
	//   - INTERNAL: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	//
	// To get the results of report generation, call
	// [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults] with the
	// [RunReportJobResponse.report_job][google.cloud.channel.v1.RunReportJobResponse.report_job].
	RunReportJob(ctx context.Context, in *RunReportJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Retrieves data generated by [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
	FetchReportResults(ctx context.Context, in *FetchReportResultsRequest, opts ...grpc.CallOption) (*FetchReportResultsResponse, error)
	// Lists the reports that RunReportJob can run. These reports include an ID,
	// a description, and the list of columns that will be in the result.
	ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error)
}

type cloudChannelReportsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudChannelReportsServiceClient(cc grpc.ClientConnInterface) CloudChannelReportsServiceClient {
	return &cloudChannelReportsServiceClient{cc}
}

func (c *cloudChannelReportsServiceClient) RunReportJob(ctx context.Context, in *RunReportJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelReportsService/RunReportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelReportsServiceClient) FetchReportResults(ctx context.Context, in *FetchReportResultsRequest, opts ...grpc.CallOption) (*FetchReportResultsResponse, error) {
	out := new(FetchReportResultsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelReportsService/FetchReportResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudChannelReportsServiceClient) ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error) {
	out := new(ListReportsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.channel.v1.CloudChannelReportsService/ListReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudChannelReportsServiceServer is the server API for CloudChannelReportsService service.
type CloudChannelReportsServiceServer interface {
	// Begins generation of data for a given report. The report
	// identifier is a UID (for example, `613bf59q`).
	//
	// Possible error codes:
	//
	//   - PERMISSION_DENIED: The user doesn't have access to this report.
	//   - INVALID_ARGUMENT: Required request parameters are missing
	//     or invalid.
	//   - NOT_FOUND: The report identifier was not found.
	//   - INTERNAL: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//   - UNKNOWN: Any non-user error related to a technical issue
	//     in the backend. Contact Cloud Channel support.
	//
	// Return value:
	// The ID of a long-running operation.
	//
	// To get the results of the operation, call the GetOperation method of
	// CloudChannelOperationsService. The Operation metadata contains an
	// instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
	//
	// To get the results of report generation, call
	// [CloudChannelReportsService.FetchReportResults][google.cloud.channel.v1.CloudChannelReportsService.FetchReportResults] with the
	// [RunReportJobResponse.report_job][google.cloud.channel.v1.RunReportJobResponse.report_job].
	RunReportJob(context.Context, *RunReportJobRequest) (*longrunning.Operation, error)
	// Retrieves data generated by [CloudChannelReportsService.RunReportJob][google.cloud.channel.v1.CloudChannelReportsService.RunReportJob].
	FetchReportResults(context.Context, *FetchReportResultsRequest) (*FetchReportResultsResponse, error)
	// Lists the reports that RunReportJob can run. These reports include an ID,
	// a description, and the list of columns that will be in the result.
	ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error)
}

// UnimplementedCloudChannelReportsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCloudChannelReportsServiceServer struct {
}

func (*UnimplementedCloudChannelReportsServiceServer) RunReportJob(context.Context, *RunReportJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunReportJob not implemented")
}
func (*UnimplementedCloudChannelReportsServiceServer) FetchReportResults(context.Context, *FetchReportResultsRequest) (*FetchReportResultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReportResults not implemented")
}
func (*UnimplementedCloudChannelReportsServiceServer) ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReports not implemented")
}

func RegisterCloudChannelReportsServiceServer(s *grpc.Server, srv CloudChannelReportsServiceServer) {
	s.RegisterService(&_CloudChannelReportsService_serviceDesc, srv)
}

func _CloudChannelReportsService_RunReportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunReportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelReportsServiceServer).RunReportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelReportsService/RunReportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelReportsServiceServer).RunReportJob(ctx, req.(*RunReportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelReportsService_FetchReportResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReportResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelReportsServiceServer).FetchReportResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelReportsService/FetchReportResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelReportsServiceServer).FetchReportResults(ctx, req.(*FetchReportResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudChannelReportsService_ListReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudChannelReportsServiceServer).ListReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.channel.v1.CloudChannelReportsService/ListReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudChannelReportsServiceServer).ListReports(ctx, req.(*ListReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudChannelReportsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.channel.v1.CloudChannelReportsService",
	HandlerType: (*CloudChannelReportsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RunReportJob",
			Handler:    _CloudChannelReportsService_RunReportJob_Handler,
		},
		{
			MethodName: "FetchReportResults",
			Handler:    _CloudChannelReportsService_FetchReportResults_Handler,
		},
		{
			MethodName: "ListReports",
			Handler:    _CloudChannelReportsService_ListReports_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/channel/v1/reports_service.proto",
}
