// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/ai/generativelanguage/v1beta/permission.proto

package generativelanguagepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines types of the grantee of this permission.
type Permission_GranteeType int32

const (
	// The default value. This value is unused.
	Permission_GRANTEE_TYPE_UNSPECIFIED Permission_GranteeType = 0
	// Represents a user. When set, you must provide email_address for the user.
	Permission_USER Permission_GranteeType = 1
	// Represents a group. When set, you must provide email_address for the
	// group.
	Permission_GROUP Permission_GranteeType = 2
	// Represents access to everyone. No extra information is required.
	Permission_EVERYONE Permission_GranteeType = 3
)

// Enum value maps for Permission_GranteeType.
var (
	Permission_GranteeType_name = map[int32]string{
		0: "GRANTEE_TYPE_UNSPECIFIED",
		1: "USER",
		2: "GROUP",
		3: "EVERYONE",
	}
	Permission_GranteeType_value = map[string]int32{
		"GRANTEE_TYPE_UNSPECIFIED": 0,
		"USER":                     1,
		"GROUP":                    2,
		"EVERYONE":                 3,
	}
)

func (x Permission_GranteeType) Enum() *Permission_GranteeType {
	p := new(Permission_GranteeType)
	*p = x
	return p
}

func (x Permission_GranteeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Permission_GranteeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_permission_proto_enumTypes[0].Descriptor()
}

func (Permission_GranteeType) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_permission_proto_enumTypes[0]
}

func (x Permission_GranteeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Permission_GranteeType.Descriptor instead.
func (Permission_GranteeType) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_permission_proto_rawDescGZIP(), []int{0, 0}
}

// Defines the role granted by this permission.
type Permission_Role int32

const (
	// The default value. This value is unused.
	Permission_ROLE_UNSPECIFIED Permission_Role = 0
	// Owner can use, update, share and delete the resource.
	Permission_OWNER Permission_Role = 1
	// Writer can use, update and share the resource.
	Permission_WRITER Permission_Role = 2
	// Reader can use the resource.
	Permission_READER Permission_Role = 3
)

// Enum value maps for Permission_Role.
var (
	Permission_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "OWNER",
		2: "WRITER",
		3: "READER",
	}
	Permission_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"OWNER":            1,
		"WRITER":           2,
		"READER":           3,
	}
)

func (x Permission_Role) Enum() *Permission_Role {
	p := new(Permission_Role)
	*p = x
	return p
}

func (x Permission_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Permission_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1beta_permission_proto_enumTypes[1].Descriptor()
}

func (Permission_Role) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1beta_permission_proto_enumTypes[1]
}

func (x Permission_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Permission_Role.Descriptor instead.
func (Permission_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_permission_proto_rawDescGZIP(), []int{0, 1}
}

// Permission resource grants user, group or the rest of the world access to the
// PaLM API resource (e.g. a tuned model, corpus).
//
// A role is a collection of permitted operations that allows users to perform
// specific actions on PaLM API resources. To make them available to users,
// groups, or service accounts, you assign roles. When you assign a role, you
// grant permissions that the role contains.
//
// There are three concentric roles. Each role is a superset of the previous
// role's permitted operations:
//
// - reader can use the resource (e.g. tuned model, corpus) for inference
// - writer has reader's permissions and additionally can edit and share
// - owner has writer's permissions and additionally can delete
type Permission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The permission name. A unique name will be
	// generated on create. Examples:
	//
	//	tunedModels/{tuned_model}/permissions/{permission}
	//	corpora/{corpus}/permissions/{permission}
	//
	// Output only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Immutable. The type of the grantee.
	GranteeType *Permission_GranteeType `protobuf:"varint,2,opt,name=grantee_type,json=granteeType,proto3,enum=google.ai.generativelanguage.v1beta.Permission_GranteeType,oneof" json:"grantee_type,omitempty"`
	// Optional. Immutable. The email address of the user of group which this
	// permission refers. Field is not set when permission's grantee type is
	// EVERYONE.
	EmailAddress *string `protobuf:"bytes,3,opt,name=email_address,json=emailAddress,proto3,oneof" json:"email_address,omitempty"`
	// Required. The role granted by this permission.
	Role *Permission_Role `protobuf:"varint,4,opt,name=role,proto3,enum=google.ai.generativelanguage.v1beta.Permission_Role,oneof" json:"role,omitempty"`
}

func (x *Permission) Reset() {
	*x = Permission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ai_generativelanguage_v1beta_permission_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission) ProtoMessage() {}

func (x *Permission) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_permission_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission.ProtoReflect.Descriptor instead.
func (*Permission) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_permission_proto_rawDescGZIP(), []int{0}
}

func (x *Permission) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Permission) GetGranteeType() Permission_GranteeType {
	if x != nil && x.GranteeType != nil {
		return *x.GranteeType
	}
	return Permission_GRANTEE_TYPE_UNSPECIFIED
}

func (x *Permission) GetEmailAddress() string {
	if x != nil && x.EmailAddress != nil {
		return *x.EmailAddress
	}
	return ""
}

func (x *Permission) GetRole() Permission_Role {
	if x != nil && x.Role != nil {
		return *x.Role
	}
	return Permission_ROLE_UNSPECIFIED
}

var File_google_ai_generativelanguage_v1beta_permission_proto protoreflect.FileDescriptor

var file_google_ai_generativelanguage_v1beta_permission_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x85, 0x05, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x0c, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52,
	0x0b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x30, 0x0a, 0x0d, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x48, 0x01,
	0x52, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x52, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x04, 0x72, 0x6f,
	0x6c, 0x65, 0x88, 0x01, 0x01, 0x22, 0x4e, 0x0a, 0x0b, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x45, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x56, 0x45, 0x52, 0x59,
	0x4f, 0x4e, 0x45, 0x10, 0x03, 0x22, 0x3f, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x57, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x57, 0x52, 0x49, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45,
	0x41, 0x44, 0x45, 0x52, 0x10, 0x03, 0x3a, 0xaa, 0x01, 0xea, 0x41, 0xa6, 0x01, 0x0a, 0x2c, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x74, 0x75, 0x6e,
	0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x2f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x12,
	0x29, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x7d, 0x2f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x0b, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x42,
	0x9b, 0x01, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0f, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5d,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ai_generativelanguage_v1beta_permission_proto_rawDescOnce sync.Once
	file_google_ai_generativelanguage_v1beta_permission_proto_rawDescData = file_google_ai_generativelanguage_v1beta_permission_proto_rawDesc
)

func file_google_ai_generativelanguage_v1beta_permission_proto_rawDescGZIP() []byte {
	file_google_ai_generativelanguage_v1beta_permission_proto_rawDescOnce.Do(func() {
		file_google_ai_generativelanguage_v1beta_permission_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ai_generativelanguage_v1beta_permission_proto_rawDescData)
	})
	return file_google_ai_generativelanguage_v1beta_permission_proto_rawDescData
}

var file_google_ai_generativelanguage_v1beta_permission_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_ai_generativelanguage_v1beta_permission_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_ai_generativelanguage_v1beta_permission_proto_goTypes = []any{
	(Permission_GranteeType)(0), // 0: google.ai.generativelanguage.v1beta.Permission.GranteeType
	(Permission_Role)(0),        // 1: google.ai.generativelanguage.v1beta.Permission.Role
	(*Permission)(nil),          // 2: google.ai.generativelanguage.v1beta.Permission
}
var file_google_ai_generativelanguage_v1beta_permission_proto_depIdxs = []int32{
	0, // 0: google.ai.generativelanguage.v1beta.Permission.grantee_type:type_name -> google.ai.generativelanguage.v1beta.Permission.GranteeType
	1, // 1: google.ai.generativelanguage.v1beta.Permission.role:type_name -> google.ai.generativelanguage.v1beta.Permission.Role
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_ai_generativelanguage_v1beta_permission_proto_init() }
func file_google_ai_generativelanguage_v1beta_permission_proto_init() {
	if File_google_ai_generativelanguage_v1beta_permission_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ai_generativelanguage_v1beta_permission_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Permission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ai_generativelanguage_v1beta_permission_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ai_generativelanguage_v1beta_permission_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ai_generativelanguage_v1beta_permission_proto_goTypes,
		DependencyIndexes: file_google_ai_generativelanguage_v1beta_permission_proto_depIdxs,
		EnumInfos:         file_google_ai_generativelanguage_v1beta_permission_proto_enumTypes,
		MessageInfos:      file_google_ai_generativelanguage_v1beta_permission_proto_msgTypes,
	}.Build()
	File_google_ai_generativelanguage_v1beta_permission_proto = out.File
	file_google_ai_generativelanguage_v1beta_permission_proto_rawDesc = nil
	file_google_ai_generativelanguage_v1beta_permission_proto_goTypes = nil
	file_google_ai_generativelanguage_v1beta_permission_proto_depIdxs = nil
}
