// Copyright 2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/plugin/check/v1/rule.proto

package checkv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the Rule.
//
// Currently, there are only two types of rules: lint rules, and breaking change rules.
// Breaking change rules require FileDescriptors to check against; if the Rule ID of a breaking change
// Rule is specified in a Check call, then against_file_descriptors are required.
type RuleType int32

const (
	// The unspecified value.
	RuleType_RULE_TYPE_UNSPECIFIED RuleType = 0
	// A lint rule.
	RuleType_RULE_TYPE_LINT RuleType = 1
	// A breaking change rule.
	RuleType_RULE_TYPE_BREAKING RuleType = 2
)

// Enum value maps for RuleType.
var (
	RuleType_name = map[int32]string{
		0: "RULE_TYPE_UNSPECIFIED",
		1: "RULE_TYPE_LINT",
		2: "RULE_TYPE_BREAKING",
	}
	RuleType_value = map[string]int32{
		"RULE_TYPE_UNSPECIFIED": 0,
		"RULE_TYPE_LINT":        1,
		"RULE_TYPE_BREAKING":    2,
	}
)

func (x RuleType) Enum() *RuleType {
	p := new(RuleType)
	*p = x
	return p
}

func (x RuleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuleType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_plugin_check_v1_rule_proto_enumTypes[0].Descriptor()
}

func (RuleType) Type() protoreflect.EnumType {
	return &file_buf_plugin_check_v1_rule_proto_enumTypes[0]
}

func (x RuleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RuleType.Descriptor instead.
func (RuleType) EnumDescriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_rule_proto_rawDescGZIP(), []int{0}
}

// A rule that a CheckService implements.
type Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Rule IDs must also be unique relative to Category IDs.
	//
	// Rule and Category IDs must be unique across all plugins used at the same time with
	// Buf. That is, no two plugins can both publish the same Rule or Category ID.
	//
	// This must have at least three characters.
	// This must start and end with a capital letter from A-Z or digits from 0-9, and only
	// consist of capital letters from A-Z, digits from 0-0, and underscores.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The IDs of the categories that the Rule is a part of.
	//
	// Buf uses categories to include or exclude sets of rules via configuration.
	//
	// Optional.
	//
	// The constraints for category IDs are the same as Rule IDs.
	CategoryIds []string `protobuf:"bytes,2,rep,name=category_ids,json=categoryIds,proto3" json:"category_ids,omitempty"`
	// Whether the Rule will be called by default if no Rule IDs are specified on a Check request.
	//
	// A deprecated Rule can never be a default Rule.
	Default bool `protobuf:"varint,3,opt,name=default,proto3" json:"default,omitempty"`
	// A user-displayable purpose of the rule.
	//
	// Required.
	//
	// This should be a proper sentence that starts with a capital letter and ends in a period.
	Purpose string `protobuf:"bytes,4,opt,name=purpose,proto3" json:"purpose,omitempty"`
	// The type of the rule.
	//
	// Required.
	Type RuleType `protobuf:"varint,5,opt,name=type,proto3,enum=buf.plugin.check.v1.RuleType" json:"type,omitempty"`
	// Whether or not this Rule is deprecated.
	//
	// If the Rule is deprecated, it may be replaced by 0 or more Rules. These will be denoted
	// by replacement_ids.
	Deprecated bool `protobuf:"varint,6,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// The IDs of the Rules that replace this Rule, if this Rule is deprecated.
	//
	// This means that the combination of the Rules specified by replacement_ids replace this Rule entirely,
	// and this Rule is considered equivalent to the AND of the rules specified by replacement_ids.
	//
	// This will only be non-empty if deprecated is true.
	// This may be empty even if deprecated is true.
	//
	// It is not valid for a deprecated Rule to specfiy another deprecated Rule as a replacement.
	ReplacementIds []string `protobuf:"bytes,7,rep,name=replacement_ids,json=replacementIds,proto3" json:"replacement_ids,omitempty"`
}

func (x *Rule) Reset() {
	*x = Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_plugin_check_v1_rule_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_rule_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rule.ProtoReflect.Descriptor instead.
func (*Rule) Descriptor() ([]byte, []int) {
	return file_buf_plugin_check_v1_rule_proto_rawDescGZIP(), []int{0}
}

func (x *Rule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Rule) GetCategoryIds() []string {
	if x != nil {
		return x.CategoryIds
	}
	return nil
}

func (x *Rule) GetDefault() bool {
	if x != nil {
		return x.Default
	}
	return false
}

func (x *Rule) GetPurpose() string {
	if x != nil {
		return x.Purpose
	}
	return ""
}

func (x *Rule) GetType() RuleType {
	if x != nil {
		return x.Type
	}
	return RuleType_RULE_TYPE_UNSPECIFIED
}

func (x *Rule) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *Rule) GetReplacementIds() []string {
	if x != nil {
		return x.ReplacementIds
	}
	return nil
}

var File_buf_plugin_check_v1_rule_proto protoreflect.FileDescriptor

var file_buf_plugin_check_v1_rule_proto_rawDesc = []byte{
	0x0a, 0x1e, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x13, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x2e, 0x76, 0x31, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xd9, 0x05, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x3a, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xba, 0x48, 0x27, 0xc8, 0x01, 0x01, 0x72,
	0x22, 0x10, 0x03, 0x18, 0x40, 0x32, 0x1c, 0x5e, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d,
	0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f, 0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d,
	0x39, 0x5d, 0x24, 0x52, 0x02, 0x69, 0x64, 0x12, 0x4f, 0x0a, 0x0c, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2c, 0xba,
	0x48, 0x29, 0x92, 0x01, 0x26, 0x22, 0x24, 0x72, 0x22, 0x10, 0x03, 0x18, 0x40, 0x32, 0x1c, 0x5e,
	0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f,
	0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x24, 0x52, 0x0b, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x12, 0x35, 0x0a, 0x07, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x1b, 0xba, 0x48, 0x18, 0xc8, 0x01, 0x01, 0x72, 0x13, 0x10, 0x02, 0x18,
	0x80, 0x02, 0x32, 0x0c, 0x5e, 0x5b, 0x41, 0x2d, 0x5a, 0x5d, 0x2e, 0x2a, 0x5b, 0x2e, 0x5d, 0x24,
	0x52, 0x07, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x2e, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2c, 0xba,
	0x48, 0x29, 0x92, 0x01, 0x26, 0x22, 0x24, 0x72, 0x22, 0x10, 0x03, 0x18, 0x40, 0x32, 0x1c, 0x5e,
	0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5f,
	0x5d, 0x2a, 0x5b, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x5d, 0x24, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x3a, 0xc0, 0x02, 0xba, 0x48,
	0xbc, 0x02, 0x1a, 0xb2, 0x01, 0x0a, 0x2a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x12, 0x36, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x74, 0x72, 0x75, 0x65, 0x20, 0x69, 0x66, 0x20, 0x72, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x20, 0x61, 0x72,
	0x65, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x1a, 0x4c, 0x21, 0x68, 0x61, 0x73, 0x28,
	0x74, 0x68, 0x69, 0x73, 0x2e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x73, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x68, 0x61, 0x73, 0x28, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x73, 0x29, 0x20, 0x26, 0x26, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x29, 0x1a, 0x84, 0x01, 0x0a, 0x20, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x5f, 0x69, 0x66, 0x5f,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x72, 0x75, 0x65, 0x12, 0x2b, 0x64, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x20, 0x69, 0x66, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x20, 0x69, 0x73, 0x20, 0x74, 0x72, 0x75, 0x65, 0x1a, 0x33, 0x21, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x20, 0x7c, 0x7c, 0x20, 0x28, 0x74, 0x68, 0x69,
	0x73, 0x2e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x20, 0x26, 0x26, 0x20, 0x21, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x29, 0x2a, 0x51,
	0x0a, 0x08, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x55,
	0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x55, 0x4c,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x42, 0x54, 0x5a, 0x52, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67,
	0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62,
	0x75, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x2f, 0x76, 0x31, 0x3b,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_plugin_check_v1_rule_proto_rawDescOnce sync.Once
	file_buf_plugin_check_v1_rule_proto_rawDescData = file_buf_plugin_check_v1_rule_proto_rawDesc
)

func file_buf_plugin_check_v1_rule_proto_rawDescGZIP() []byte {
	file_buf_plugin_check_v1_rule_proto_rawDescOnce.Do(func() {
		file_buf_plugin_check_v1_rule_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_plugin_check_v1_rule_proto_rawDescData)
	})
	return file_buf_plugin_check_v1_rule_proto_rawDescData
}

var file_buf_plugin_check_v1_rule_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_plugin_check_v1_rule_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_plugin_check_v1_rule_proto_goTypes = []any{
	(RuleType)(0), // 0: buf.plugin.check.v1.RuleType
	(*Rule)(nil),  // 1: buf.plugin.check.v1.Rule
}
var file_buf_plugin_check_v1_rule_proto_depIdxs = []int32{
	0, // 0: buf.plugin.check.v1.Rule.type:type_name -> buf.plugin.check.v1.RuleType
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_buf_plugin_check_v1_rule_proto_init() }
func file_buf_plugin_check_v1_rule_proto_init() {
	if File_buf_plugin_check_v1_rule_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_buf_plugin_check_v1_rule_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_plugin_check_v1_rule_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_check_v1_rule_proto_goTypes,
		DependencyIndexes: file_buf_plugin_check_v1_rule_proto_depIdxs,
		EnumInfos:         file_buf_plugin_check_v1_rule_proto_enumTypes,
		MessageInfos:      file_buf_plugin_check_v1_rule_proto_msgTypes,
	}.Build()
	File_buf_plugin_check_v1_rule_proto = out.File
	file_buf_plugin_check_v1_rule_proto_rawDesc = nil
	file_buf_plugin_check_v1_rule_proto_goTypes = nil
	file_buf_plugin_check_v1_rule_proto_depIdxs = nil
}
