/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class Api<O extends ApiOptions> {
    private final zza<?, O> zzWi;
    private final zzc<?, O> zzWj;
    private final ClientKey<?> zzVu;
    private final zzd<?> zzWk;
    private final ArrayList<Scope> zzWl;
    private final String mName;

    public <C extends Client> Api(String name, zza<C, O> clientBuilder, ClientKey<C> clientKey, Scope ... impliedScopes) {
        zzu.zzb(clientBuilder, (Object)"Cannot construct an Api with a null ClientBuilder");
        zzu.zzb(clientKey, (Object)"Cannot construct an Api with a null ClientKey");
        this.mName = name;
        this.zzWi = clientBuilder;
        this.zzWj = null;
        this.zzVu = clientKey;
        this.zzWk = null;
        this.zzWl = new ArrayList<Scope>(Arrays.asList(impliedScopes));
    }

    public zza<?, O> zzmp() {
        zzu.zza(this.zzWi != null, (Object)"This API was constructed with a SimpleClientBuilder. Use getSimpleClientBuilder");
        return this.zzWi;
    }

    public zzc<?, O> zzmq() {
        zzu.zza(this.zzWj != null, (Object)"This API was constructed with a ClientBuilder. Use getClientBuilder");
        return this.zzWj;
    }

    public List<Scope> zzmr() {
        return this.zzWl;
    }

    public ClientKey<?> zzms() {
        zzu.zza(this.zzVu != null, (Object)"This API was constructed with a SimpleClientKey. Use getSimpleClientKey");
        return this.zzVu;
    }

    public boolean zzmt() {
        return this.zzWk != null;
    }

    public String getName() {
        return this.mName;
    }

    public static interface zzb<T extends IInterface> {
        public String getStartServiceAction();

        public String getServiceDescriptor();

        public T zzT(IBinder var1);
    }

    public static interface Client {
        public void connect(GoogleApiClient.ConnectionProgressReportCallbacks var1);

        public void disconnect();

        public boolean isConnected();

        public boolean isConnecting();

        public void validateAccount(IAccountAccessor var1);

        public void getRemoteService(IAccountAccessor var1, Set<Scope> var2);

        public boolean requiresSignIn();

        public boolean requiresAccount();

        public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);
    }

    public static final class zzd<C extends zzb> {
    }

    public static final class ClientKey<C extends Client> {
    }

    public static interface ApiOptions {

        public static final class NoOptions
        implements NotRequiredOptions {
            private NoOptions() {
            }
        }

        public static interface Optional
        extends HasOptions,
        NotRequiredOptions {
        }

        public static interface HasOptions
        extends ApiOptions {
        }

        public static interface NotRequiredOptions
        extends ApiOptions {
        }
    }

    public static interface zzc<T extends zzb, O> {
        public T zzl(O var1);

        public int zzmu();
    }

    public static interface zza<T extends Client, O> {
        public T zza(Context var1, Looper var2, zze var3, O var4, GoogleApiClient.ConnectionCallbacks var5, GoogleApiClient.OnConnectionFailedListener var6);

        public int getPriority();
    }
}

