/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzgd;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

@zzgd
public class zzd
extends zzfe.zza {
    private String zzqr;
    private Context mContext;
    private String zzAK;
    private ArrayList<String> zzAL;

    public zzd(String string2, ArrayList<String> arrayList, Context context, String string3) {
        this.zzAK = string2;
        this.zzAL = arrayList;
        this.zzqr = string3;
        this.mContext = context;
    }

    @Override
    public String getProductId() {
        return this.zzAK;
    }

    protected int zzy(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        return 0;
    }

    protected String zza(String string2, HashMap<String, String> hashMap) {
        String string3 = this.mContext.getPackageName();
        String string4 = "";
        try {
            string4 = this.mContext.getPackageManager().getPackageInfo((String)string3, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzb.zzd("Error to retrieve app version", nameNotFoundException);
        }
        long l = zzo.zzby().zzfX().zzgg();
        long l2 = SystemClock.elapsedRealtime() - l;
        for (String string5 : hashMap.keySet()) {
            string2 = string2.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", string5), String.format("$1%s$2", hashMap.get(string5)));
        }
        return string2.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "sessionid"), String.format("$1%s$2", zzo.zzby().getSessionId())).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "appid"), String.format("$1%s$2", string3)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "osversion"), String.format("$1%s$2", String.valueOf(Build.VERSION.SDK_INT))).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "sdkversion"), String.format("$1%s$2", this.zzqr)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "appversion"), String.format("$1%s$2", string4)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "timestamp"), String.format("$1%s$2", String.valueOf(l2))).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "[^@]+"), String.format("$1%s$2", "")).replaceAll("@@", "@");
    }

    @Override
    public void recordResolution(int resolution) {
        if (resolution == 1) {
            this.zzff();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("status", String.valueOf(resolution));
        hashMap.put("sku", this.zzAK);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : this.zzAL) {
            linkedList.add(this.zza(string2, hashMap));
        }
        zzo.zzbv().zza(this.mContext, this.zzqr, linkedList);
    }

    @Override
    public void recordPlayBillingResolution(int billingResponseCode) {
        if (billingResponseCode == 0) {
            this.zzff();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("google_play_status", String.valueOf(billingResponseCode));
        hashMap.put("sku", this.zzAK);
        hashMap.put("status", String.valueOf(this.zzy(billingResponseCode)));
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : this.zzAL) {
            linkedList.add(this.zza(string2, hashMap));
        }
        zzo.zzbv().zza(this.mContext, this.zzqr, linkedList);
    }

    void zzff() {
        try {
            Class<?> clazz = this.mContext.getClassLoader().loadClass("com.google.ads.conversiontracking.IAPConversionReporter");
            Method method = clazz.getDeclaredMethod("reportWithProductId", Context.class, String.class, String.class, Boolean.TYPE);
            method.invoke(null, this.mContext, this.zzAK, "", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            zzb.zzaC("Google Conversion Tracking SDK 1.2.0 or above is required to report a conversion.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            zzb.zzaC("Google Conversion Tracking SDK 1.2.0 or above is required to report a conversion.");
        }
        catch (Exception exception) {
            zzb.zzd("Fail to report a conversion.", exception);
        }
    }
}

