/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.zzlc;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int zzCY;
    private final GameEntity zzaud;
    private final String zzapF;
    private final String zzauA;
    private final long zzaue;
    private final String zzauI;
    private final long zzaoj;
    private final String zzauJ;
    private final int zzauK;
    private final int zzaui;
    private final int mVersion;
    private final byte[] zzauL;
    private final ArrayList<ParticipantEntity> zzauh;
    private final String zzauM;
    private final byte[] zzauN;
    private final int zzauO;
    private final Bundle zzauy;
    private final int zzauP;
    private final boolean zzauQ;
    private final String zzakM;
    private final String zzauR;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.zzCY = 2;
        this.zzaud = new GameEntity(match.getGame());
        this.zzapF = match.getMatchId();
        this.zzauA = match.getCreatorId();
        this.zzaue = match.getCreationTimestamp();
        this.zzauI = match.getLastUpdaterId();
        this.zzaoj = match.getLastUpdatedTimestamp();
        this.zzauJ = match.getPendingParticipantId();
        this.zzauK = match.getStatus();
        this.zzauP = match.getTurnStatus();
        this.zzaui = match.getVariant();
        this.mVersion = match.getVersion();
        this.zzauM = match.getRematchId();
        this.zzauO = match.getMatchNumber();
        this.zzauy = match.getAutoMatchCriteria();
        this.zzauQ = match.isLocallyModified();
        this.zzakM = match.getDescription();
        this.zzauR = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.zzauL = null;
        } else {
            this.zzauL = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzauL, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzauN = null;
        } else {
            this.zzauN = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzauN, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n = arrayList.size();
        this.zzauh = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzauh.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.zzCY = versionCode;
        this.zzaud = game;
        this.zzapF = matchId;
        this.zzauA = creatorId;
        this.zzaue = creationTimestamp;
        this.zzauI = lastUpdaterId;
        this.zzaoj = lastUpdatedTimestamp;
        this.zzauJ = pendingParticipantId;
        this.zzauK = matchStatus;
        this.zzauP = turnStatus;
        this.zzaui = variant;
        this.mVersion = version;
        this.zzauL = data;
        this.zzauh = participants;
        this.zzauM = rematchId;
        this.zzauN = previousData;
        this.zzauO = matchNumber;
        this.zzauy = autoMatchCriteria;
        this.zzauQ = isLocallyModified;
        this.zzakM = description;
        this.zzauR = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public Game getGame() {
        return this.zzaud;
    }

    @Override
    public String getMatchId() {
        return this.zzapF;
    }

    @Override
    public String getCreatorId() {
        return this.zzauA;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaue;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzauI;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaoj;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzauJ;
    }

    @Override
    public int getStatus() {
        return this.zzauK;
    }

    @Override
    public int getTurnStatus() {
        return this.zzauP;
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzauR;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string2 = this.getDescriptionParticipantId();
        if (string2 == null) {
            return null;
        }
        return this.getParticipant(string2);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb(this.zzakM, dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzaui;
    }

    @Override
    public byte[] getData() {
        return this.zzauL;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.zzauM;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzauN;
    }

    @Override
    public int getMatchNumber() {
        return this.zzauO;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzauy;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzauy == null) {
            return 0;
        }
        return this.zzauy.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzauK == 2 && this.zzauM == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzauQ;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.zzc(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzauh);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzt.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, obj);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzt.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && zzt.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && zzt.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && zzt.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && zzt.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && zzt.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && zzt.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && zzt.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && zzt.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && zzt.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && zzt.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && zzt.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && zzt.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && zzt.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && zzt.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && zzt.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && zzt.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && zzt.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzt.zzt(turnBasedMatch).zzg("Game", turnBasedMatch.getGame()).zzg("MatchId", turnBasedMatch.getMatchId()).zzg("CreatorId", turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", turnBasedMatch.getStatus()).zzg("TurnStatus", turnBasedMatch.getTurnStatus()).zzg("Description", turnBasedMatch.getDescription()).zzg("Variant", turnBasedMatch.getVariant()).zzg("Data", turnBasedMatch.getData()).zzg("Version", turnBasedMatch.getVersion()).zzg("Participants", turnBasedMatch.getParticipants()).zzg("RematchId", turnBasedMatch.getRematchId()).zzg("PreviousData", turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.zza(this, out, flags);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string2) {
        String string3 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }
}

