/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.fitness.data.BleDevice;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BleDevicesResult
implements Result,
SafeParcelable {
    private final int zzCY;
    private final List<BleDevice> zzamO;
    private final Status zzOt;
    public static final Parcelable.Creator<BleDevicesResult> CREATOR = new zza();

    BleDevicesResult(int versionCode, List<BleDevice> bleDevices, Status status) {
        this.zzCY = versionCode;
        this.zzamO = Collections.unmodifiableList(bleDevices);
        this.zzOt = status;
    }

    public BleDevicesResult(List<BleDevice> bleDevices, Status status) {
        this.zzCY = 3;
        this.zzamO = Collections.unmodifiableList(bleDevices);
        this.zzOt = status;
    }

    public static BleDevicesResult zzJ(Status status) {
        return new BleDevicesResult(Collections.emptyList(), status);
    }

    public List<BleDevice> getClaimedBleDevices() {
        return this.zzamO;
    }

    public List<BleDevice> getClaimedBleDevices(DataType dataType) {
        ArrayList<BleDevice> arrayList = new ArrayList<BleDevice>();
        for (BleDevice bleDevice : this.zzamO) {
            if (!bleDevice.getDataTypes().contains(dataType)) continue;
            arrayList.add(bleDevice);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Status getStatus() {
        return this.zzOt;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof BleDevicesResult && this.zzb((BleDevicesResult)that);
    }

    private boolean zzb(BleDevicesResult bleDevicesResult) {
        return this.zzOt.equals(bleDevicesResult.zzOt) && zzt.equal(this.zzamO, bleDevicesResult.zzamO);
    }

    public int hashCode() {
        return zzt.hashCode(this.zzOt, this.zzamO);
    }

    public String toString() {
        return zzt.zzt(this).zzg("status", this.zzOt).zzg("bleDevices", this.zzamO).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }
}

