/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.internal.DeleteResourceRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.ListParentsRequest;
import com.google.android.gms.drive.internal.OnListParentsResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.SetResourceParentsRequest;
import com.google.android.gms.drive.internal.TrashResourceRequest;
import com.google.android.gms.drive.internal.UntrashResourceRequest;
import com.google.android.gms.drive.internal.UpdateMetadataRequest;
import com.google.android.gms.drive.internal.zzal;
import com.google.android.gms.drive.internal.zzbq;
import com.google.android.gms.drive.internal.zzn;
import com.google.android.gms.drive.internal.zzq;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import java.util.ArrayList;
import java.util.Set;

public class zzz
implements DriveResource {
    protected final DriveId zzacT;

    protected zzz(DriveId driveId) {
        this.zzacT = driveId;
    }

    @Override
    public DriveId getDriveId() {
        return this.zzacT;
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> getMetadata(GoogleApiClient apiClient) {
        return this.zza(apiClient, false);
    }

    private PendingResult<DriveResource.MetadataResult> zza(GoogleApiClient googleApiClient, final boolean bl) {
        return googleApiClient.zza(new zzd(googleApiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new GetMetadataRequest(zzz.this.zzacT, bl), (zzal)new zzb(this));
            }
        });
    }

    @Override
    public PendingResult<DriveApi.MetadataBufferResult> listParents(GoogleApiClient apiClient) {
        return apiClient.zza(new zzq.zzg(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new ListParentsRequest(zzz.this.zzacT), (zzal)new zza(this));
            }
        });
    }

    @Override
    public PendingResult<Status> setParents(GoogleApiClient apiClient, Set<DriveId> parentIds) {
        if (parentIds == null) {
            throw new IllegalArgumentException("ParentIds must be provided.");
        }
        if (parentIds.isEmpty()) {
            throw new IllegalArgumentException("ParentIds must contain at least one parent.");
        }
        final ArrayList<DriveId> arrayList = new ArrayList<DriveId>(parentIds);
        return apiClient.zzb(new zzr.zza(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new SetResourceParentsRequest(zzz.this.zzacT, arrayList), (zzal)new zzbq(this));
            }
        });
    }

    @Override
    public PendingResult<DriveResource.MetadataResult> updateMetadata(GoogleApiClient apiClient, final MetadataChangeSet changeSet) {
        if (changeSet == null) {
            throw new IllegalArgumentException("ChangeSet must be provided.");
        }
        return apiClient.zzb(new zzd(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                changeSet.zzpm().setContext(zzs2.getContext());
                zzs2.zzpB().zza(new UpdateMetadataRequest(zzz.this.zzacT, changeSet.zzpm()), (zzal)new zzb(this));
            }
        });
    }

    @Override
    public PendingResult<Status> delete(GoogleApiClient apiClient) {
        return apiClient.zzb(new zzr.zza(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new DeleteResourceRequest(zzz.this.zzacT), (zzal)new zzbq(this));
            }
        });
    }

    @Override
    public PendingResult<Status> addChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzs zzs2 = apiClient.zza(Drive.zzNX);
        return zzs2.zza(apiClient, this.zzacT, listener);
    }

    @Override
    public PendingResult<Status> removeChangeListener(GoogleApiClient apiClient, ChangeListener listener) {
        zzs zzs2 = apiClient.zza(Drive.zzNX);
        return zzs2.zzb(apiClient, this.zzacT, listener);
    }

    @Override
    public PendingResult<Status> addChangeSubscription(GoogleApiClient apiClient) {
        zzs zzs2 = apiClient.zza(Drive.zzNX);
        return zzs2.zza(apiClient, this.zzacT);
    }

    @Override
    public PendingResult<Status> removeChangeSubscription(GoogleApiClient apiClient) {
        zzs zzs2 = apiClient.zza(Drive.zzNX);
        return zzs2.zzb(apiClient, this.zzacT);
    }

    @Override
    public PendingResult<Status> trash(GoogleApiClient apiClient) {
        return apiClient.zzb(new zzr.zza(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new TrashResourceRequest(zzz.this.zzacT), (zzal)new zzbq(this));
            }
        });
    }

    @Override
    public PendingResult<Status> untrash(GoogleApiClient apiClient) {
        return apiClient.zzb(new zzr.zza(apiClient){

            @Override
            protected void zza(zzs zzs2) throws RemoteException {
                zzs2.zzpB().zza(new UntrashResourceRequest(zzz.this.zzacT), (zzal)new zzbq(this));
            }
        });
    }

    private static class zza
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveApi.MetadataBufferResult> zzOs;

        public zza(zza.zzb<DriveApi.MetadataBufferResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(OnListParentsResponse onListParentsResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListParentsResponse.zzpR());
            this.zzOs.zzm(new zzq.zzf(Status.zzXP, metadataBuffer, false));
        }

        @Override
        public void zzt(Status status) throws RemoteException {
            this.zzOs.zzm(new zzq.zzf(status, null, false));
        }
    }

    private static class zzb
    extends com.google.android.gms.drive.internal.zzd {
        private final zza.zzb<DriveResource.MetadataResult> zzOs;

        public zzb(zza.zzb<DriveResource.MetadataResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.zzOs.zzm(new zzc(Status.zzXP, new zzn(onMetadataResponse.zzpS())));
        }

        @Override
        public void zzt(Status status) throws RemoteException {
            this.zzOs.zzm(new zzc(status, null));
        }
    }

    private static class zzc
    implements DriveResource.MetadataResult {
        private final Status zzOt;
        private final Metadata zzafA;

        public zzc(Status status, Metadata metadata) {
            this.zzOt = status;
            this.zzafA = metadata;
        }

        @Override
        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public Metadata getMetadata() {
            return this.zzafA;
        }
    }

    private abstract class zzd
    extends zzr<DriveResource.MetadataResult> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public DriveResource.MetadataResult zzA(Status status) {
            return new zzc(status, null);
        }

        @Override
        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzA(x0);
        }
    }
}

