/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

public class StringArrayList {
    static final int maxGrowIncrement = 0xCCCCCCC;
    int size = 0;
    String[] values;

    public StringArrayList(int maxSize) {
        this.values = new String[maxSize];
    }

    public void add(String v) {
        if (this.size >= this.values.length) {
            this.grow();
        }
        this.values[this.size] = v;
        ++this.size;
    }

    public String get(int idx) {
        if (idx >= this.size) {
            throw new IndexOutOfBoundsException("Index out of bounds.  Size = " + this.size + " Index = " + idx);
        }
        return this.values[idx];
    }

    public String[] toArray() {
        this.trim();
        return this.values;
    }

    private void grow() {
        if (this.values.length >= Integer.MAX_VALUE) {
            throw new RuntimeException("Maximum array size exceeded");
        }
        int increment = (int)Math.max(1000.0, 0.2 * (double)this.values.length);
        int newSize = Math.min(Integer.MAX_VALUE, this.values.length + increment);
        this.resize(newSize);
    }

    private void resize(int newSize) {
        String[] tmp = new String[newSize];
        System.arraycopy(this.values, 0, tmp, 0, Math.min(tmp.length, this.values.length));
        this.values = tmp;
    }

    private void trim() {
        this.resize(this.size);
    }
}

