/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public abstract class AbstractNumericOperator
implements InfixOperator {
    protected static final Number ZERO = new BigDecimal(0.0);
    private static final long serialVersionUID = -1087959445157130705L;

    protected AbstractNumericOperator() {
    }

    public final TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        if (value1 == null || value2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        Object raw1 = value1.getValue();
        Object raw2 = value2.getValue();
        if (raw1 == null || raw2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Number number1 = AbstractNumericOperator.convertToNumber(typeRegistry, value1.getType(), raw1, ZERO);
        Number number2 = AbstractNumericOperator.convertToNumber(typeRegistry, value2.getType(), raw2, ZERO);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, this.evaluate(number1, number2));
    }

    protected abstract Number evaluate(Number var1, Number var2) throws EvaluationException;

    private static Number convertToNumber(TypeRegistry registry, Type type, Object value, Number defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return registry.convertToNumber(type, value);
        }
        catch (EvaluationException e) {
            return defaultValue;
        }
    }
}

