/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.io;

import gnu.kawa.io.InPort;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.Path;
import gnu.mapping.Procedure;
import gnu.mapping.ThreadLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class TtyInPort
extends InPort {
    protected OutPort tie;
    protected Procedure prompter;
    public static final ThreadLocation<String> prompt1 = new ThreadLocation("prompt1");
    public static final ThreadLocation<String> prompt2 = new ThreadLocation("prompt2");
    boolean inDomTerm;
    int prompt1Length = 0;
    protected boolean promptEmitted;

    public void setInDomTerm(boolean v) {
        this.inDomTerm = v;
    }

    public Procedure getPrompter() {
        return this.prompter;
    }

    public void setPrompter(Procedure prompter) {
        this.prompter = prompter;
    }

    public String defaultPrompt() {
        if (this.readState == '\n') {
            return "";
        }
        int line = this.getLineNumber() + 1;
        if (this.readState == ' ') {
            String pattern = prompt1.get("");
            String str = this.expandPrompt(pattern, 0, line, "");
            this.prompt1Length = str.length();
            return str;
        }
        String pattern = prompt2.get("");
        String m = new String(new char[]{this.readState});
        String str = this.expandPrompt(pattern, this.prompt1Length, line, m);
        return str;
    }

    public String expandPrompt(String pattern, int padToWidth, int line, String message) {
        StringBuilder sb = new StringBuilder();
        int plen = pattern.length();
        int padChar = -1;
        int padPos = -1;
        int i = 0;
        block6: while (i < plen) {
            char ch;
            if ((ch = pattern.charAt(i++)) == '%' && i < plen) {
                ch = pattern.charAt(i++);
                int count = -1;
                while (ch >= '0' && ch <= '9') {
                    count = (count < 0 ? 0 : 10 * count) + (ch - 48);
                    ch = pattern.charAt(i++);
                }
                switch (ch) {
                    case '%': {
                        sb.append(ch);
                        break;
                    }
                    case 'N': {
                        sb.append(line);
                        break;
                    }
                    case 'M': {
                        if (message == null) continue block6;
                        sb.append(message);
                        break;
                    }
                    case 'P': {
                        if (count >= 0) {
                            padToWidth = count;
                        }
                        if (i < plen) {
                            padChar = pattern.charAt(i++);
                        }
                        padPos = sb.length();
                        break;
                    }
                    default: {
                        --i;
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        String str = sb.toString();
        int cols = str.length();
        if (padToWidth > cols) {
            int padCharCols = 1;
            int padCount = (padToWidth - cols) / padCharCols;
            while (--padCount >= 0) {
                sb.insert(padPos, (char)padChar);
            }
            str = sb.toString();
        }
        return str;
    }

    public TtyInPort(InputStream in, Path name, OutPort tie) {
        super(in, name);
        this.setConvertCR(true);
        this.tie = tie;
    }

    public TtyInPort(Reader in, Path name, OutPort tie) {
        super(in, name);
        this.setConvertCR(true);
        this.tie = tie;
    }

    @Override
    protected int fill(int len) throws IOException {
        int count = this.in.read(this.buffer, this.pos, len);
        if (this.tie != null && count > 0) {
            this.tie.echo(this.buffer, this.pos, count);
        }
        return count;
    }

    protected void afterFill(int count) throws IOException {
        if (this.tie != null && count > 0) {
            this.tie.echo(this.buffer, this.pos, count);
        }
    }

    public void emitPrompt(String prompt) throws IOException {
        this.tie.print(prompt);
        this.tie.flush();
        this.tie.clearBuffer();
    }

    public String wrapPromptForAnsi(String prompt) {
        return "\u001b[48;5;120m" + prompt + "\u001b[0m";
    }

    public String wrapPromptForDomTerm(String prompt) {
        if (this.inDomTerm) {
            boolean haveDomTermEscapes = false;
            int i = prompt.length();
            while (--i >= 4 && !haveDomTermEscapes) {
                if (prompt.charAt(i) != 'u' || prompt.charAt(i - 4) != '\u001b' || prompt.charAt(i - 3) != '[') continue;
                haveDomTermEscapes = true;
            }
            if (!haveDomTermEscapes) {
                prompt = "\u001b[14u" + prompt + "\u001b[15u";
            }
        }
        return prompt;
    }

    @Override
    public void lineStart(boolean revisited) throws IOException {
        if (!revisited) {
            this.promptEmitted = false;
            if (this.prompter != null) {
                try {
                    String string;
                    String prompt;
                    String string2 = this.readState == '\n' ? null : (prompt = this.readState == ' ' ? this.prompter.apply1(this) : this.defaultPrompt());
                    if (prompt != null && (string = prompt.toString()) != null && string.length() > 0) {
                        if (this.tie != null) {
                            this.tie.freshLine();
                        }
                        this.emitPrompt(this.wrapPromptForDomTerm(string));
                        this.promptEmitted = true;
                    }
                }
                catch (Throwable ex) {
                    throw new IOException("Error when evaluating prompt:" + ex);
                }
            }
            if (this.tie != null && !this.promptEmitted) {
                this.tie.flush();
                this.tie.clearBuffer();
            }
        }
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((ch = super.read()) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((count = super.read(cbuf, off, len)) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return count;
    }

    public static TtyInPort make(InputStream in, Path name, OutPort tie) {
        try {
            return (TtyInPort)Class.forName("gnu.kawa.io.JLineInPort").getConstructor(InputStream.class, Path.class, OutPort.class).newInstance(in, name, tie);
        }
        catch (Throwable throwable) {
            return new TtyInPort(in, name, tie);
        }
    }
}

