/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.Pattern;
import kawa.lang.Translator;

public class SyntaxRule
implements Externalizable {
    Pattern pattern;
    String template_program;
    int num_variables;
    String pattern_nesting;
    int max_nesting;
    Object[] literal_values;
    static final String dots3 = "...";
    static final int RCONS = 1;
    static final int LIST1 = 2;
    static final int START_REPEAT = 3;
    static final int END_REPEAT = 4;
    static final int FIRST_VARS = 5;
    static final int FIRST_LITERALS = 6;

    public SyntaxRule() {
    }

    public SyntaxRule(Pattern pattern, String string, String string2, Object[] objectArray, int n) {
        this.pattern = pattern;
        this.pattern_nesting = string;
        this.template_program = string2;
        this.literal_values = objectArray;
        this.max_nesting = n;
        this.num_variables = string.length();
    }

    public SyntaxRule(Pattern pattern, String string, Vector vector, Object object2, Vector vector2, Translator translator) {
        this.pattern = pattern;
        this.pattern_nesting = string;
        this.num_variables = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector3 = new Vector();
        this.translate_template(object2, stringBuffer, vector, 0, vector3, vector2, 0, translator);
        this.template_program = stringBuffer.toString();
        this.literal_values = new Object[vector3.size()];
        vector3.copyInto(this.literal_values);
    }

    public void translate_template(Object object2, StringBuffer stringBuffer, Vector vector, int n, Vector vector2, Vector vector3, int n2, Translator translator) {
        int n3;
        if (object2 instanceof Pair) {
            int n4;
            Pair pair = (Pair)object2;
            if (pair.cdr instanceof Pair) {
                Pair pair2 = (Pair)pair.cdr;
                if (pair2.car == dots3) {
                    this.translate_template(pair2.cdr, stringBuffer, vector, n, vector2, vector3, n2, translator);
                    stringBuffer.append('\u0003');
                    if (n >= this.max_nesting) {
                        this.max_nesting = n + 1;
                    }
                    this.translate_template(pair.car, stringBuffer, vector, n + 1, vector2, vector3, n2, translator);
                    stringBuffer.append('\u0004');
                    return;
                }
            }
            if (pair.cdr == LList.Empty) {
                n4 = 2;
            } else {
                n4 = 1;
                int n5 = n2;
                if (pair.car == "quote") {
                    n5 = -1;
                } else if (pair.car == "quasiquote" && n5 >= 0) {
                    ++n5;
                } else if ((pair.car == "unquote" || pair.car == "unquote-splicing") && n5 > 0) {
                    --n5;
                }
                this.translate_template(pair.cdr, stringBuffer, vector, n, vector2, vector3, n5, translator);
            }
            this.translate_template(pair.car, stringBuffer, vector, n, vector2, vector3, n2, translator);
            stringBuffer.append((char)n4);
            return;
        }
        if (object2 instanceof String) {
            n3 = SyntaxRule.indexOf(vector, object2);
            if (n3 >= 0) {
                if (this.pattern_nesting.charAt(n3) > n) {
                    translator.syntaxError("inconsistent ... nesting of " + object2);
                }
                stringBuffer.append((char)(5 + 2 * n3));
                return;
            }
            if (n2 == 0 && object2 != "quote" && object2 != "quasiquote" && object2 != "unquote" && object2 != "unquote-splicing") {
                int n6 = SyntaxRule.indexOf(vector3, object2);
                if (n6 < 0) {
                    n6 = vector3.size();
                    vector3.addElement(object2);
                }
                n3 = n6 + this.num_variables;
                stringBuffer.append((char)(5 + 2 * n3));
                return;
            }
        }
        if ((n3 = SyntaxRule.indexOf(vector2, object2)) < 0) {
            n3 = vector2.size();
            vector2.addElement(object2);
        }
        stringBuffer.append((char)(6 + 2 * n3));
    }

    private static int indexOf(Vector vector, Object object2) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (vector.elementAt(i) != object2) continue;
            return i;
        }
        return -1;
    }

    Object execute_template(int n, Object[] objectArray, int n2, int[] nArray, Translator translator, Pair pair) {
        Stack<Object> stack = new Stack<Object>();
        int n3 = this.template_program.length();
        for (int i = n; i < n3; ++i) {
            char c = this.template_program.charAt(i);
            if (c == '\u0001') {
                Object e = stack.pop();
                Object object2 = stack.pop();
                object2 = i + 1 == n3 && pair instanceof PairWithPosition ? new PairWithPosition((PairWithPosition)pair, e, object2) : new Pair(e, object2);
                stack.push(object2);
                continue;
            }
            if (c == '\u0002') {
                Object e = stack.pop();
                stack.push(new Pair(e, LList.Empty));
                continue;
            }
            if (c == '\u0003') {
                Object object3;
                int n4 = -1;
                n = i + 1;
                int n5 = 0;
                i = n;
                while (true) {
                    int n6;
                    if ((c = this.template_program.charAt(i)) == '\u0003') {
                        ++n5;
                    } else if (c == '\u0004') {
                        if (n5 == 0) break;
                        --n5;
                    } else if (c >= '\u0005' && (c & '\u0001') == 1 && (n6 = c - 5 >> 1) < this.num_variables) {
                        object3 = objectArray[n6];
                        char c2 = this.pattern_nesting.charAt(n6);
                        if (c2 > n2) {
                            for (int j = 0; j < n2; ++j) {
                                object3 = ((Object[])object3)[nArray[j]];
                            }
                            Object[] objectArray2 = (Object[])object3;
                            if (n4 == -1) {
                                n4 = objectArray2.length;
                            } else if (n4 != objectArray2.length) {
                                translator.syntaxError("inconsistent lengths of repeated variables");
                                n4 = 0;
                            }
                        }
                    }
                    ++i;
                }
                if (n4 < 0) {
                    translator.syntaxError("... follows template with no suitably-nested pattern variable");
                    n4 = 0;
                }
                Pair pair2 = null;
                object3 = stack.pop();
                LList lList = LList.Empty;
                for (int j = 0; j < n4; ++j) {
                    nArray[n2] = j;
                    Object object4 = this.execute_template(n, objectArray, n2 + 1, nArray, translator, pair);
                    Pair pair3 = new Pair(object4, LList.Empty);
                    if (pair2 == null) {
                        lList = pair3;
                    } else {
                        pair2.cdr = pair3;
                    }
                    pair2 = pair3;
                }
                if (pair2 == null) {
                    lList = object3;
                } else {
                    pair2.cdr = object3;
                }
                stack.push(lList);
                continue;
            }
            if (c == '\u0004') break;
            if ((c & '\u0001') == 0) {
                stack.push(this.literal_values[c - 6 >> 1]);
                continue;
            }
            int n7 = c - 5 >> 1;
            Object object5 = objectArray[n7];
            if (n7 < this.pattern_nesting.length()) {
                int n8 = this.pattern_nesting.charAt(n7);
                for (int j = 0; j < n8; ++j) {
                    object5 = ((Object[])object5)[nArray[j]];
                }
            }
            stack.push(object5);
        }
        return stack.pop();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.pattern);
        objectOutput.writeObject(this.pattern_nesting);
        objectOutput.writeObject(this.template_program);
        objectOutput.writeObject(this.literal_values);
        objectOutput.writeInt(this.max_nesting);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.pattern = (Pattern)objectInput.readObject();
        this.pattern_nesting = (String)objectInput.readObject();
        this.template_program = (String)objectInput.readObject();
        this.literal_values = (Object[])objectInput.readObject();
        this.max_nesting = objectInput.readInt();
    }
}

