/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.EWindow;
import gnu.lists.LList;

public abstract class EFrame {
    public static EFrame selectedFrame;
    public EWindow selectedWindow;
    static int counter;
    protected int id = ++counter;
    public EWindow firstWindow;

    public static String defaultName() {
        return "Emacs";
    }

    public EFrame() {
        if (selectedFrame == null) {
            selectedFrame = this;
        }
    }

    public EFrame(EWindow win) {
        win.frame = this;
        this.firstWindow = win;
        win.nextWindow = win;
        win.prevWindow = win;
        EWindow.setSelected(win);
    }

    public void validate() {
    }

    public void delete() {
        EWindow win;
        while ((win = this.firstWindow) != null) {
            win.deleteNoValidate();
        }
        if (this == selectedFrame) {
            selectedFrame = null;
        }
    }

    public abstract boolean isLive();

    public EWindow getFirstWindow() {
        return this.firstWindow;
    }

    public EWindow getLastWindow() {
        return this.firstWindow.prevWindow;
    }

    public static EFrame getSelectedFrame() {
        return selectedFrame;
    }

    public EWindow getSelectedWindow() {
        return this.selectedWindow;
    }

    public EWindow otherWindow(int count) {
        return this.selectedWindow.getNextWindowInFrame(count);
    }

    public abstract void setMenuBar(LList var1);

    public abstract String ask(String var1);

    public String toString() {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append("#<frame #");
        sbuf.append(this.id);
        sbuf.append('>');
        return sbuf.toString();
    }
}

