20 March 2018

#### Support for OpenStack
Calico v3.1 reintroduces support for OpenStack. Users can now upgrade their Calico
OpenStack clusters to v3.1 to take advantage of the new capabilities
introduced in the Calico v3 release series. To upgrade an existing cluster,
[follow the documented procedure](https://docs.projectcalico.org/v3.1/getting-started/openstack/upgrade/).

#### Introducing GlobalNetworkSets
Calico now supports a new resource type: GlobalNetworkSet.  A GlobalNetworkSet contains a set of CIDRs
with associated labels, which can be matched by GlobalNetworkPolicies.
This allows for rules to refer to external networks, possibly consisting of thousands of CIDRs.
GlobalNetworkSets allow you to write network policies that are more portable across
clusters by introducing a label-based abstraction on top of network CIDRs. To learn more,
see the [GlobalNetworkSet resource definition](https://docs.projectcalico.org/v3.1/reference/calicoctl/resources/globalnetworkset).

#### Beta support for IPVS kube-proxy
Calico v3.1 moves support for the IPVS kube-proxy from alpha to beta, supporting pod ingress,
pod egress and host endpoint network policy. The IPVS kube-proxy is still beta, but promises greater scale and performance
compared to the existing iptables proxy.

#### Kubernetes IPv6 support
While Calico has always had native IPv6 support, Calico v3.1 includes fixes which better support running an IPv6 based Kubernetes
cluster. In Calico v3.1, you can now use the Kubernetes API datastore in IPv6 mode.
Additionally, Calico now generates a /48 ULA prefix when no IPv6 pool is specified rather than using a fixed CIDR.
This prevents multiple Calico clusters from sharing the same IPv6 address space.

#### HostEndpoint support for Kubernetes API data store
Calico now supports configuration of host endpoints when using the Kubernetes API datastore. This allows you to seamlessly
apply network policy directly to Kubernetes host machines and Kubernetes pods alike using Calico global network policies.


#### Other changes
- The install-cni container now maintains the original mode on certificates copied from Kubernetes secrets. [cni-plugin #481](https://github.com/projectcalico/cni-plugin/pull/481) (@caseydavenport)
- The install-cni container now writes the calico-kubeconfig file with mode 600 by default. It can be configured by setting the KUBECONFIG_MODE option. [cni-plugin #481](https://github.com/projectcalico/cni-plugin/pull/481) (@caseydavenport)
- The Calico CNI plugin by default expects the /var/lib/calico/nodename file to be created by calico/node. To disable this feature, set `nodename_file_optional: true` in your CNI network configuration. [cni-plugin #480](https://github.com/projectcalico/cni-plugin/pull/480) (@caseydavenport)
- Fixes a bug where IPs could be assigned from disabled IP pools. [libcalico-go #806](https://github.com/projectcalico/libcalico-go/pull/806) (@ozdanborne)
- Fixes a bug where profiles were periodically and unnecessarily reprogrammed by kube-controllers. [libcalico-go #805](https://github.com/projectcalico/libcalico-go/pull/805) (@caseydavenport)
- Fixes a bug where nodes were periodically and unnecessarily processed by kube-controllers. [kube-controllers #216](https://github.com/projectcalico/kube-controllers/pull/216) (@caseydavenport)
- Closes a number of race conditions and failure scenarios in IPAM block allocation and releasing. [libcalico-go #785](https://github.com/projectcalico/libcalico-go/pull/785) (@caseydavenport)
- Improves log output around IPAM block allocation and releasing. [libcalico-go #785](https://github.com/projectcalico/libcalico-go/pull/785) (@caseydavenport)
- The self-hosted Kubernetes manifests now set mode 400 for TLS secrets by default [calico #1725](https://github.com/projectcalico/calico/pull/1725) (@caseydavenport)
- Fixes a rare bug where a node could in some circumstances advertise /26 blocks that it didn't own [calico #1712](https://github.com/projectcalico/calico/pull/1712) (@caseydavenport)
- Use networking.k8s.io api in place of deprecated extensions/v1beta1. [calico #1614](https://github.com/projectcalico/calico/pull/1614) (@bcreane)
- Fixes an interaction between failsafe inbound/outbound ports and do-not-track policy that resulted in failsafe ports being blocked if do-not-track policy was added. [felix #1718](https://github.com/projectcalico/felix/pull/1718) (@fasaxc)
- Fix bug in icmp validation where ipVersion was required for all icmp rules. [calicoctl #1814](https://github.com/projectcalico/calicoctl/pull/1814) (@ozdanborne)

#### Limitations

- **Offers only Kubernetes, OpenShift, OpenStack, and host endpoint integrations**: the
Mesos, DC/OS, rkt, and Docker orchestrators have not been tested
and are not supported. (Calico still supports Docker and rkt containers.)
We plan to resume support for the Mesos, DC/OS, and Docker
orchestrators in a future release.

- **GoBGP not supported**: Setting the `CALICO_NETWORKING_BACKEND` environment
variable to `gobgp` is not supported. See [Configuring calico/node](https://docs.projectcalico.org/v3.1/reference/node/configuration)
for more information. We plan to resume support for GoBGP in a future release.

- **Route reflectors cannot be clustered**: We plan to resume support for
this in a future release.
