30 Apr 2019

#### Native support for VXLAN encapsulation

Calico now includes native support for encapsulating traffic between
workloads using VXLAN, in addition to existing support for IP in IP
encapsulation.

While IP in IP is slightly more efficient in terms of encapsulation
overhead, there are some networks that do not allow IP in IP traffic,
for example Azure and DigitalOcean. VXLAN support in Calico means you
can now use Calico to network workloads in these environments.

 - Felix programs VXLAN routes [felix #1989](https://github.com/projectcalico/felix/pull/1989) (@caseydavenport)
 - VXLAN encapsulation can now be configured per IP pool [libcalico-go #1065](https://github.com/projectcalico/libcalico-go/pull/1065) (@caseydavenport)

For more information, see the [Calico documentation](https://docs.projectcalico.org/v3.7/networking/vxlan-ipip).

#### Optimized denial-of-service protection for host endpoints using XDP

Calico now automatically enforces specific types of blacklist policies
at the earliest possible point in the packet processing pipeline,
including offloading to NIC hardware whenever possible.

 - Dataplane: optimize early host-endpoint blacklist rules [felix #1991](https://github.com/projectcalico/felix/pull/1991) (@iaguis)
 - [calico #2546](https://github.com/projectcalico/calico/pull/2546) (@iaguis)

For more information, see the [HOWTO guide](https://docs.projectcalico.org/v3.7/security/defend-dos-attack) and our upcoming blog post.

#### Namespaced NetworkSets

Global network sets have existed in Calico since v3.1.0. They provide
a way to group IP addresses and apply labels to the group to be used
in a global network policy.

Calico v3.7.0 introduces support for the NetworkSet resource, which
allows for the same functionality but within the scope of a particular
Namespace. This is useful if you want to be able to reference a set of
IP addresses using a selector from a namespaced network policy
resource.

- Add NetworkSet resource. NetworkSets are the namespaced-equivalent of GlobalNetworkSet. [libcalico-go #1055](https://github.com/projectcalico/libcalico-go/pull/1055) (@lmm)

For more information, see the [Calico documentation](https://docs.projectcalico.org/v3.7/reference/calicoctl/resources/networkset).

#### Bug fixes

 - Reinstate BGP route aggregation when using host-local IPAM via config option USE_POD_CIDR [libcalico-go #1077](https://github.com/projectcalico/libcalico-go/pull/1077) (@caseydavenport)
 - Fix issues related to apiserver disconnection [libcalico-go #1057](https://github.com/projectcalico/libcalico-go/pull/1057) (@caseydavenport)
 - Fix hash-based router ID calculation for IPv4 [confd #231](https://github.com/projectcalico/confd/pull/231) (@roshanirathi)

#### Other changes

 - amd64 images now use debian instead of alpine as base [node #202](https://github.com/projectcalico/node/pull/202) (@stevegaossou)
 - Allow the entries for the exclude interface parameter to be regular expression patterns [felix #1980](https://github.com/projectcalico/felix/pull/1980) (@stevegaossou)
 - Health aggregator now only logs if overall health status has changed. Details of unhealthy reporters are now logged. [libcalico-go #1064](https://github.com/projectcalico/libcalico-go/pull/1064) (@lmm)
 - Improve `calico/node` readiness probe reporting when watches on the datastore error out. [libcalico-go #1063](https://github.com/projectcalico/libcalico-go/pull/1063) (@lmm)
 - Validate that protocol is set correctly if an HTTPMatch is specified in a NetworkPolicy [libcalico-go #1048](https://github.com/projectcalico/libcalico-go/pull/1048) (@jpalardy)
 - Auto update ipv6 router id based on nodename [confd #215](https://github.com/projectcalico/confd/pull/215) (@roshanirathi)
 - Retry on error when configuring IPv6 interfaces (@CallMeFoxie) [cni-plugin #731](https://github.com/projectcalico/cni-plugin/pull/731) (@caseydavenport)
 - Update to CNI plugins v0.7.5 [cni-plugin #713](https://github.com/projectcalico/cni-plugin/pull/713) (@lwr20)
 - Enhance canal manifest with etcd datastore to include read access to namespaces for canal cluster role. [calico #2566](https://github.com/projectcalico/calico/pull/2566) (@asincu)
 - Update Typha's Kubernetes readiness check to call Typha directly [calico #2482](https://github.com/projectcalico/calico/pull/2482) (@roshanirathi)
 - Simplify Kubernetes manifest URL locations. Existing URLs have been left intact, but will be removed in a future release. Please update any tooling to use the new manifest URLs. [calico #2437](https://github.com/projectcalico/calico/pull/2437) (@caseydavenport)
