[![Go Report Card](https://goreportcard.com/badge/github.com/projectcalico/calico)](https://goreportcard.com/report/github.com/projectcalico/calico)
[![ArtifactHub](https://img.shields.io/endpoint?url=https://artifacthub.io/badge/repository/tigera-operator)](https://artifacthub.io/packages/helm/projectcalico/tigera-operator)
[![License](https://img.shields.io/badge/license-Apache-blue.svg)](calico/LICENSE)
[![GoPkg](https://pkg.go.dev/badge/k8s.io/kubernetes.svg)](https://pkg.go.dev/github.com/projectcalico/api)
[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/6064/badge)](https://bestpractices.coreinfrastructure.org/projects/6064)

<div align=center>
<h1>Calico</h1>
<h2>
<a href="https://projectcalico.docs.tigera.io/getting-started/kubernetes/quickstart">Quickstart</a> |
<a href="https://projectcalico.docs.tigera.io">Docs</a> |
<a href="CONTRIBUTING.md">Contribute</a> |
<a href="https://slack.projectcalico.org">Slack</a> |
<a href="https://github.com/projectcalico/calico/releases">Releases</a>
</h2>
</div>

## 🐾 Welcome to Project Calico!

Project Calico, created and maintained by [Tigera][tigera], is an open-source project with an active development and user community. Calico Open Source has grown to be the most widely adopted solution for container networking and security, powering 8M+ nodes daily across 166 countries.

## 🌟 Why use Calico?

- **Data Plane Choice**: eBPF, standard Linux, Windows, and VPP — versatility in network solutions.
- **Interoperability**: Works across multiple distros, multiple clouds, bare metal, and VMs.
- **Optimized Performance**: Engineered for high speed and low CPU usage, maximizing your cluster investments.
- **Scalable Architecture**: Grows seamlessly with your Kubernetes clusters without sacrificing performance.
- **Advanced Security**: Get granular access controls and WireGuard encryption.
- **Kubernetes Networking Policy Support**: Continually defining excellence in Kubernetes network policy standards and support.
- **Vibrant Contributor Community**: Over 200 contributors from a wide array of global companies.
- **Flexible networking**: An array of networking tools at your disposal, including BGP, VXLAN, service advertisement, and more.

<div align=center>
<img src="https://www.tigera.io/app/uploads/2024/02/Ecosystem_shrunken_2023.svg">
</div>

## 🤝 Join the Calico Community

- [Calico Big Cats][big-cats]: Become an ambassador and share your journey
- [Community Meetings][community-meetings]: Engage and contribute
- [Contribute on GitHub][first-issues]: Start with 'good first issues'
- [Connect on Slack][slack]: Join the conversation with fellow contributors and our developers

## 💡 Contributing to Project Calico

- [Get Started with Project Calico][get-started]
- [Repositories][repos]
- [Contribute to our docs][docs-contrib]
- Documentation: [Dive into our training and resources][resources]
- [Make Calico better][issues]

## 🛠️ Projects We Maintain

- [Calico Golang API][api]
- [Calico operator][operator]
- [VPP dataplane][vpp]
- [Calico BIRD][bird]

## 📢 Stay Connected

- Subscribe: [Join our newsletter][news]
- [YouTube channel for updates & tutorials][youtube]
- [Technical Blog][blog]
- [Careers][join]: Passionate about open source? Join our team.

[tigera]: https://www.tigera.io/
[big-cats]: https://www.tigera.io/project-calico/calico-big-cats-ambassador-program/#meet-calico-big-cats
[community-meetings]: https://calendar.google.com/calendar/u/0/embed?src=tigera.io_uunmavdev5ndovf0hc4frtl0i0@group.calendar.google.com
[first-issues]: https://github.com/projectcalico/calico/labels/good%20first%20issue
[slack]: https://slack.projectcalico.org/
[get-started]: https://docs.tigera.io/calico/latest/about
[repos]: https://github.com/orgs/projectcalico/repositories
[docs-contrib]: https://github.com/projectcalico/calico/blob/master/CONTRIBUTING_DOCS.md
[resources]: https://docs.tigera.io/calico/latest/about/training-resources
[issues]: https://github.com/projectcalico/calico/issues
[api]: https://github.com/projectcalico/api
[operator]: https://github.com/tigera/operator
[vpp]: https://github.com/projectcalico/vpp-dataplane
[news]: https://www.tigera.io/project-calico/#:~:text=Join%20Calico%20Open%20Source%20community%20newsletter
[youtube]: https://www.youtube.com/channel/UCFpTnXDNcBoXI4gqCDmegFA
[blog]: https://www.tigera.io/blog/?_sft_category=technical-blog
[join]: https://www.tigera.io/careers/
[bird]: https://github.com/projectcalico/bird
