24 May 2023

#### Improved Security

Permissions for core Calico components have been separated and reduced to the minimum required for each component. This change allows us to tweak permissions on the CNI plugin itself regardless of the permissions required to manage the dataplane.

Pull Requests:

 - Separate calico-node and calico-cni-plugin service accounts [calico #7106](https://github.com/projectcalico/calico/pull/7106) (@MichalFupso)

#### Performance Enhancements

Calico now utilizes kernel-side route filtering in order to reduce CPU usage in systems with many different pods.

Pull Requests:

 - Performance: use kernel-side route filtering when listing routes in the interface monitor.  Dramatically reduces CPU usage (and garbage collection) on systems with many interfaces/routes. [calico #7375](https://github.com/projectcalico/calico/pull/7375) (@fasaxc)
 - Performance: use kernel-side route filtering when listing routes.  Dramatically reduces CPU usage (and garbage collection) on systems with many interfaces/pods/routes. [calico #7364](https://github.com/projectcalico/calico/pull/7364) (@fasaxc)

#### Windows Server 2022 Support

Calico now supports Windows Server 2022!

#### OpenStack Yoga Support

Calico now supports OpenStack Yoga!

Pull Requests:

 - OpenStack: Support newer, more scalable version of etcd server [calico #7147](https://github.com/projectcalico/calico/pull/7147) (@nelljerram)

#### Bug fixes

##### General

 - Fix 'error while loading shared libraries: libresolv.so.2: cannot open shared object file' on csi-node-driver-registrar. [calico #7587](https://github.com/projectcalico/calico/pull/7587) (@coutinhop)
 - Fix the auto iptables detection if ip_tables.ko preloaded on RHEL/CentOS 8 [calico #7111](https://github.com/projectcalico/calico/pull/7111) (@yankay)
 - Update pin to use fixed calico/bird image no fix node ST failures. [calico #7562](https://github.com/projectcalico/calico/pull/7562) (@coutinhop)
 - Prevents Node kube-controller's internal pod cache from getting out-of-sync thus leaking memory. [calico #7433](https://github.com/projectcalico/calico/pull/7433) (@dilyevsky)
 - Fix high CPU usage in syncL2RoutesForLink: ignore incomplete ARP entries when cleaning up the FDB table. Prevents us from telling the kernel to delete an FDB entry with no HwAddr, which fails triggering a retry loop. [calico #7421](https://github.com/projectcalico/calico/pull/7421) (@detailyang)
 - Ensure that veths are created with the proper default values from the kernel. [calico #7358](https://github.com/projectcalico/calico/pull/7358) (@radixo)
 - Fix that the tunnel IP allocator did not respond to changes in the IP pool's allowedUses field. [calico #7357](https://github.com/projectcalico/calico/pull/7357) (@fasaxc)
 - s390x: fix image mislabel in cni, typha and kube-controllers [calico #7333](https://github.com/projectcalico/calico/pull/7333) (@huoqifeng)
 - Remove usage of deprecated '--logtostderr' command line flag. [calico #7294](https://github.com/projectcalico/calico/pull/7294) (@coutinhop)
 - Fix that Calico API server would reuse UUIDs from the underlying CRD objects that underpin the datamodel (thus confusing Kubernetes ownership tracking and ArgoCD).  This will result in the apparent UUIDs of calico "v3" resources changing over upgrade.  This was unavoidable in order to split them from the underlying CRD UUIDs. [calico #7291](https://github.com/projectcalico/calico/pull/7291) (@fasaxc)
 - Fix generation of `operator-crds.yaml` manifest. [calico #7216](https://github.com/projectcalico/calico/pull/7216) (@caseydavenport)
 - Fix that, if a Typha client loads the list of Typha instances just before they all get upgraded, it takes 30s+ to time out.  Reload the list of Typha instances between each connection attempt. [calico #7176](https://github.com/projectcalico/calico/pull/7176) (@fasaxc)

##### eBPF

 - ebpf: prevents infinite restarts when we switch to ebpf after kube-proxy was in ipvs mode. [calico #7174](https://github.com/projectcalico/calico/pull/7174) (@StevenTigera)

#### Other changes

##### General

 - When running Calico in policy-only mode, do not write the IP annotations to the node. [calico #7632](https://github.com/projectcalico/calico/pull/7632) (@mgleung)
 - Introduce new BGPFilter resource [calico #7271](https://github.com/projectcalico/calico/pull/7271) (@Josh-Tigera)
 - Enable s390x architecture support [calico #7249](https://github.com/projectcalico/calico/pull/7249) (@huoqifeng)
 - ocp.tgz now hosted on GitHub [calico #7189](https://github.com/projectcalico/calico/pull/7189) (@caseydavenport)
 - Replace misleading BUG: logs in the Typha client. [calico #7172](https://github.com/projectcalico/calico/pull/7172) (@fasaxc)
 - Add ability to set the deny action as REJECT instead of DROP [calico #5735](https://github.com/projectcalico/calico/pull/5735) (@olljanat)

##### eBPF

 - ebpf: rules that mark established flows from before ebpf was turned on are installed asap to make transition smoother [calico #7526](https://github.com/projectcalico/calico/pull/7526) (@tomastigera)
 - ebpf: BPFEnforceRPF is Loose by default to avoid issues in some environments. If Strict option is required,it has to be set explicitly and the BPFDataIfacePattern may need to be changed accordingly to avoid attaching to "slave" devices. [calico #7518](https://github.com/projectcalico/calico/pull/7518) (@tomastigera)
 - ebpf: Jumpmap versionincremented to prevent failures when upgrading from earlier calico versions [calico #7484](https://github.com/projectcalico/calico/pull/7484) (@tomastigera)
 - ebpf: Topology Aware Hints supported when/where provided by k8s. [calico #7241](https://github.com/projectcalico/calico/pull/7241) (@StevenTigera)
 - ebpf: Setting BPFDSROptoutCIDRs to a list of CIDRs allows clients from these CIDRs to opt out from DSR when DSR is enabled. We recommend enabling DSR and setting BPFDSROptoutCIDRs to 168.63.129.16/32 in AKS. [calico #7211](https://github.com/projectcalico/calico/pull/7211) (@tomastigera)
