11 Sep 2019

#### Support live migration from flannel to Calico

Calico now supports migration of existing flannel and canal cluster to use Calico VXLAN networking and network policy enforcement. See the
[getting started documentation](https://docs.projectcalico.org/v3.9/getting-started/kubernetes/installation/migration-from-flannel) for more information.

 - Add controller to migrate Flannel configuration to Calico [kube-controllers #389](https://github.com/projectcalico/kube-controllers/pull/389) (@song-jiang)

#### Cross-subnet VXLAN encapsulation

Calico can now selectively perform VXLAN encapsulation only for traffic which crosses a subnet boundary. This is similar to the existing functionality when using
IP-in-IP encapsulation. This feature is useful in situations where encapsulation is not required within an L2 domain (for example, and AWS subnet) but is required for
crossing a subnet boundary. For more information, see [the documentation](https://docs.projectcalico.org/v3.9/networking/vxlan-ipip).

 - Add ability to configure VXLAN in cross-subnet mode [libcalico-go #1114](https://github.com/projectcalico/libcalico-go/pull/1114) (@Brian-McM)
 - Add VXLANMode CrossSubnet so routes use the VXLAN interface only when the destination is on a node in a different subnet [felix #2101](https://github.com/projectcalico/felix/pull/2101) (@Brian-McM)
 - Enable writing Felix routes with a dedicated route protocol set to differentiate routes originated by Felix. [felix #2118](https://github.com/projectcalico/felix/pull/2118) (@Marlinc)
 - Add Felix configuration option to ignore external routes on Calico-owned interfaces. [libcalico-go #1119](https://github.com/projectcalico/libcalico-go/pull/1119) (@Marlinc)
 - Add Felix configuration option to set custom routing protocol on Calico-owned routes. [libcalico-go #1119](https://github.com/projectcalico/libcalico-go/pull/1119) (@Marlinc)

#### Bug fixes

 - Fix that enabling VXLAN required restarting the calico/node pod [confd #256](https://github.com/projectcalico/confd/pull/256) (@rene-dekker)
 - Remove tunnel address even if no other BGP configuration exists [node #257](https://github.com/projectcalico/node/pull/257) (@caseydavenport)
 - Fix issues where tunnel ip been reused incorrectly in kdd mode. [node #254](https://github.com/projectcalico/node/pull/254) (@song-jiang)
 - Fix Felix readiness checks when using non-default port [node #241](https://github.com/projectcalico/node/pull/241) (@jadech32)
 - Fix race condition where a non-Calico rule may be deleted. [felix #2088](https://github.com/projectcalico/felix/pull/2088) (@lmm)
 - Fix that tunnel addresses were not released on node deletion when using etcd data store. [libcalico-go #1111](https://github.com/projectcalico/libcalico-go/pull/1111) (@caseydavenport)
 - Fix missing calicoctl RBAC for viewing networking.k8s.io network policies [calico #2750](https://github.com/projectcalico/calico/pull/2750) (@fpicot)

#### Other changes

 - Respect etcd configuration options when datastore type is implicitly determined to be etcdv3. [felix #2085](https://github.com/projectcalico/felix/pull/2085) (@Brian-McM)
 - Support configuring Felix's Prometheus metrics bind address [felix #2081](https://github.com/projectcalico/felix/pull/2081) (@rene-dekker)
 - Support configurable port for Felix readiness and liveness probes [calico #2634](https://github.com/projectcalico/calico/pull/2634) (@jadech32)
 - Felix now supports iptables 1.8 in nftables mode.  The correct mode must be selected through configuration. [felix #2070](https://github.com/projectcalico/felix/pull/2070) (@fasaxc)
 - Add config option for iptables backend [libcalico-go #1102](https://github.com/projectcalico/libcalico-go/pull/1102) (@tmjd)
 - Add support for setting the source hint on routes programmed by Felix using the DeviceRouteSourceAddress configuration parameter. [felix #2037](https://github.com/projectcalico/felix/pull/2037) (@maxstr)
 - Add DeviceRouteSourceAddress option to FelixConfig [libcalico-go #1097](https://github.com/projectcalico/libcalico-go/pull/1097) (@maxstr)
 - Fix that kube-controllers would reconcile policies unnecessarily. [libcalico-go #1107](https://github.com/projectcalico/libcalico-go/pull/1107) (@rikatz)
 - Dikastes runs as a nonroot user by default for improved security [app-policy #96](https://github.com/projectcalico/app-policy/pull/96) (@spikecurtis)
 - Retry on node update conflict in IPAM upgrade script [cni-plugin #760](https://github.com/projectcalico/cni-plugin/pull/760) (@sbueringer)
 - Dikastes runs as non-root user for improved security. [calico #2765](https://github.com/projectcalico/calico/pull/2765) (@spikecurtis)
 - Prometheus host is now configurable [calico #2728](https://github.com/projectcalico/calico/pull/2728) (@rene-dekker)
