/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.crypt;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.wicket.util.crypt.ICrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJceCrypt
implements ICrypt {
    private static final Logger log = LoggerFactory.getLogger(AbstractJceCrypt.class);

    public final String decryptUrlSafe(String text) {
        try {
            byte[] decoded = Base64.getUrlDecoder().decode(text);
            return new String(this.decrypt(decoded), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            log.debug("Error decoding text: {}", (Object)text, (Object)ex);
            return null;
        }
    }

    public final String encryptUrlSafe(String plainText) {
        byte[] encrypted = this.encrypt(plainText.getBytes(StandardCharsets.UTF_8));
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        byte[] encoded = encoder.encode(encrypted);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    protected abstract byte[] decrypt(byte[] var1);

    protected abstract byte[] encrypt(byte[] var1);

    public final void setKey(String key) {
        throw new UnsupportedOperationException("This method has been deprecated in ICrypt and will be removed.");
    }
}

