/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public final class CssUtils {
    public static final String INLINE_OPEN_TAG = "<style type=\"text/css\"><!--\n";
    public static final String INLINE_CLOSE_TAG = "--></style>\n";

    private CssUtils() {
    }

    public static void writeCss(Response response, CharSequence text, String id) {
        CssUtils.writeOpenTag(response, id);
        response.write(text);
        CssUtils.writeCloseTag(response);
    }

    public static void writeOpenTag(Response response, String id) {
        response.write((CharSequence)"<style type=\"text/css\" ");
        if (id != null) {
            response.write((CharSequence)("id=\"" + id + "\""));
        }
        response.write((CharSequence)"><!--\n");
    }

    public static void writeCloseTag(Response response) {
        response.write((CharSequence)INLINE_CLOSE_TAG);
    }

    public static void writeLinkUrl(Response response, CharSequence url, CharSequence media) {
        response.write((CharSequence)"<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        response.write(Strings.escapeMarkup((CharSequence)url));
        response.write((CharSequence)"\"");
        if (media != null) {
            response.write((CharSequence)" media=\"");
            response.write(Strings.escapeMarkup((CharSequence)media));
            response.write((CharSequence)"\"");
        }
        response.write((CharSequence)" />");
    }

    public static String key(Class<?> scope, String facet) {
        return scope.getSimpleName() + ".CSS." + facet;
    }
}

