/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Duration;

public final class AjaxRequestAttributes {
    public static final String XML_DATA_TYPE = "xml";
    private boolean multipart = false;
    private Method method = Method.GET;
    private Duration requestTimeout;
    private boolean allowDefault = false;
    private EventPropagation eventPropagation = EventPropagation.STOP;
    private String[] eventNames = new String[0];
    private String formId;
    private String submittingComponentName;
    private boolean wicketAjaxResponse = true;
    private String dataType = "xml";
    private List<IAjaxCallListener> ajaxCallListeners;
    private Map<String, Object> extraParameters;
    private List<CharSequence> dynamicExtraParameters;
    private AjaxChannel channel;
    private boolean async = true;
    private ThrottlingSettings throttlingSettings;
    private CharSequence childSelector;
    private boolean serializeRecursively;

    public CharSequence getChildSelector() {
        return this.childSelector;
    }

    public void setChildSelector(CharSequence childSelector) {
        this.childSelector = childSelector;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public AjaxRequestAttributes setMultipart(boolean multipart) {
        this.multipart = multipart;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public AjaxRequestAttributes setMethod(Method method) {
        this.method = (Method)((Object)Args.notNull((Object)((Object)method), (String)"method"));
        return this;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public AjaxRequestAttributes setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public List<IAjaxCallListener> getAjaxCallListeners() {
        if (this.ajaxCallListeners == null) {
            this.ajaxCallListeners = new ArrayList<IAjaxCallListener>();
        }
        return this.ajaxCallListeners;
    }

    public Map<String, Object> getExtraParameters() {
        if (this.extraParameters == null) {
            this.extraParameters = new HashMap<String, Object>();
        }
        return this.extraParameters;
    }

    public List<CharSequence> getDynamicExtraParameters() {
        if (this.dynamicExtraParameters == null) {
            this.dynamicExtraParameters = new ArrayList<CharSequence>();
        }
        return this.dynamicExtraParameters;
    }

    public boolean isAllowDefault() {
        return this.allowDefault;
    }

    public EventPropagation getEventPropagation() {
        return this.eventPropagation;
    }

    public AjaxRequestAttributes setAllowDefault(boolean allowDefault) {
        this.allowDefault = allowDefault;
        return this;
    }

    public AjaxRequestAttributes setEventPropagation(EventPropagation eventPropagation) {
        this.eventPropagation = (EventPropagation)((Object)Args.notNull((Object)((Object)eventPropagation), (String)"eventPropagation"));
        return this;
    }

    public AjaxRequestAttributes setAsynchronous(boolean async) {
        this.async = async;
        return this;
    }

    public boolean isAsynchronous() {
        return this.async;
    }

    public AjaxChannel getChannel() {
        return this.channel;
    }

    public AjaxRequestAttributes setChannel(AjaxChannel channel) {
        this.channel = channel;
        return this;
    }

    public String[] getEventNames() {
        return this.eventNames;
    }

    public AjaxRequestAttributes setEventNames(String ... eventNames) {
        Args.notNull((Object)eventNames, (String)"eventNames");
        this.eventNames = eventNames;
        return this;
    }

    public String getFormId() {
        return this.formId;
    }

    public AjaxRequestAttributes setFormId(String formId) {
        this.formId = formId;
        return this;
    }

    public String getSubmittingComponentName() {
        return this.submittingComponentName;
    }

    public AjaxRequestAttributes setSubmittingComponentName(String submittingComponentName) {
        this.submittingComponentName = submittingComponentName;
        return this;
    }

    public boolean isWicketAjaxResponse() {
        return this.wicketAjaxResponse;
    }

    public AjaxRequestAttributes setWicketAjaxResponse(boolean wicketAjaxResponse) {
        this.wicketAjaxResponse = wicketAjaxResponse;
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public AjaxRequestAttributes setDataType(String dataType) {
        this.dataType = (String)Args.notEmpty((CharSequence)dataType, (String)"dataType");
        return this;
    }

    public ThrottlingSettings getThrottlingSettings() {
        return this.throttlingSettings;
    }

    public AjaxRequestAttributes setThrottlingSettings(ThrottlingSettings throttlingSettings) {
        this.throttlingSettings = throttlingSettings;
        return this;
    }

    public boolean isSerializeRecursively() {
        return this.serializeRecursively;
    }

    public AjaxRequestAttributes setSerializeRecursively(boolean serializeRecursively) {
        this.serializeRecursively = serializeRecursively;
        return this;
    }

    public static enum EventPropagation {
        STOP,
        STOP_IMMEDIATE,
        BUBBLE;

    }

    public static enum Method {
        GET,
        POST;


        public String toString() {
            return this.name();
        }
    }
}

