/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.versionmigrator.internal;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.versionmigrator.ClassRefactor;
import org.apache.tapestry5.versionmigrator.FileRefactorCommitParser;

public class PackageAndArtifactChangeRefactorCommitParser
implements FileRefactorCommitParser {
    public static final String EXAMPLE = "{tapestry-ioc/src/main/java/org/apache/tapestry5/ioc => commons/src/main/java/org/apache/tapestry5/commons}/ObjectProvider.java";
    private static final Pattern PATTERN = Pattern.compile("\\{([^\\/]+)\\/([^\\s]+)\\s=>\\s([^\\/]+)\\/([^}]+)}([^\\.]+).*");

    @Override
    public Optional<ClassRefactor> apply(String line) {
        ClassRefactor move = null;
        Matcher matcher = PATTERN.matcher(line);
        if (matcher.matches()) {
            String newPackageNameSuffix = FileRefactorCommitParser.extractPackageOrClassName(matcher.group(4));
            String oldPackageNameSuffix = FileRefactorCommitParser.extractPackageOrClassName(matcher.group(2));
            String className = matcher.group(5);
            String newClassName = FileRefactorCommitParser.buildClassName("", newPackageNameSuffix, className);
            String oldClassName = FileRefactorCommitParser.buildClassName("", oldPackageNameSuffix, className);
            String sourceArtifactName = matcher.group(1);
            String destinationArtifactName = matcher.group(3);
            move = new ClassRefactor(newClassName, oldClassName, sourceArtifactName, destinationArtifactName);
        }
        return Optional.ofNullable(move);
    }
}

