/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.structure;

import java.util.Arrays;
import java.util.List;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.internal.structure.StructureMessages;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;

class RenderPhaseEventHandler
implements ComponentEventCallback {
    private final RenderQueue renderQueue;
    private boolean result = true;
    private List<RenderCommand> commands;

    public RenderPhaseEventHandler(RenderQueue renderQueue) {
        this.renderQueue = renderQueue;
    }

    boolean getResult() {
        return this.result;
    }

    void enqueueSavedRenderCommands() {
        if (this.commands != null) {
            for (RenderCommand command : this.commands) {
                this.renderQueue.push(command);
            }
        }
    }

    public boolean handleResult(Object result) {
        if (result instanceof Boolean) {
            this.result = (Boolean)result;
            return true;
        }
        if (result instanceof RenderCommand) {
            RenderCommand command = (RenderCommand)result;
            this.add(command);
            return false;
        }
        if (result instanceof Renderable) {
            final Renderable renderable = (Renderable)result;
            RenderCommand wrapper = new RenderCommand(){

                @Override
                public void render(MarkupWriter writer, RenderQueue queue) {
                    renderable.render(writer);
                }
            };
            this.add(wrapper);
            return false;
        }
        throw new RuntimeException(StructureMessages.wrongPhaseResultType(Arrays.asList(Boolean.class.getName(), Renderable.class.getName(), RenderCommand.class.getName())));
    }

    private void add(RenderCommand command) {
        if (this.commands == null) {
            this.commands = CollectionFactory.newList();
        }
        this.commands.add(command);
    }
}

