/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.services.MarkupRenderer;
import org.apache.tapestry5.services.MarkupRendererFilter;

public class AddBrowserCompatibilityStyles
implements MarkupRendererFilter {
    private final String ie9;
    private final String ie8;

    public AddBrowserCompatibilityStyles() {
        this(0.25);
    }

    public AddBrowserCompatibilityStyles(double opacity) {
        this.ie9 = String.format("<!--[if IE 9]><style type=\"text/css\">.pageloading-mask{opacity:%.2f;}</style><![endif]-->", opacity);
        this.ie8 = String.format("<!--[if lt IE 9]><style type=\"text/css\">.pageloading-mask{filter:alpha(opacity=%d);}</style><![endif]-->", (int)(100.0 * opacity));
    }

    @Override
    public void renderMarkup(MarkupWriter writer, MarkupRenderer renderer) {
        renderer.renderMarkup(writer);
        Element head = writer.getDocument().find("html/head");
        if (head != null) {
            head.raw(this.ie9);
            head.raw(this.ie8);
        }
    }
}

