/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.services.InvalidationListener;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.slf4j.Logger;

public class InvalidationEventHubImpl
implements InvalidationEventHub {
    private final List<Function<List<String>, List<String>>> callbacks;
    private final Logger logger;

    protected InvalidationEventHubImpl(boolean productionMode, Logger logger) {
        this.callbacks = productionMode ? null : CollectionFactory.newThreadSafeList();
        this.logger = logger;
    }

    protected final void fireInvalidationEvent() {
        this.fireInvalidationEvent(Collections.emptyList());
    }

    public final void fireInvalidationEvent(List<String> resources) {
        HashSet extraResources;
        if (this.callbacks == null) {
            return;
        }
        HashSet<String> alreadyProcessed = new HashSet<String>();
        int level = 1;
        do {
            extraResources = new HashSet();
            if (!resources.isEmpty()) {
                this.logger.info("Invalidating {} resource(s) at level {}: {}", new Object[]{resources.size(), level, String.join((CharSequence)", ", resources)});
            } else {
                this.logger.info("Invalidating all resources");
            }
            for (Function<List<String>, List<String>> callback : this.callbacks) {
                List<String> newResources = callback.apply(resources);
                if (newResources == null) {
                    throw new TapestryException("InvalidationEventHub callback functions cannot return null", null);
                }
                Set actuallyNewResources = newResources.stream().filter(r -> !alreadyProcessed.contains(r)).collect(Collectors.toSet());
                extraResources.addAll(actuallyNewResources);
                alreadyProcessed.addAll(newResources);
            }
            ++level;
        } while (!(resources = new ArrayList<String>(extraResources)).isEmpty());
    }

    public final void addInvalidationCallback(Runnable callback) {
        assert (callback != null);
        if (this.callbacks != null) {
            this.callbacks.add(r -> {
                callback.run();
                return Collections.emptyList();
            });
        }
    }

    public final void clearOnInvalidation(final Map<?, ?> map) {
        assert (map != null);
        this.addInvalidationCallback(new Runnable(){

            @Override
            public void run() {
                map.clear();
            }
        });
    }

    public final void addInvalidationListener(final InvalidationListener listener) {
        assert (listener != null);
        this.addInvalidationCallback(new Runnable(){

            @Override
            public void run() {
                listener.objectWasInvalidated();
            }
        });
    }

    public void addInvalidationCallback(Function<List<String>, List<String>> callback) {
        if (this.callbacks != null) {
            this.callbacks.add(callback);
        }
    }
}

