/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.dom;

import java.util.Collections;
import java.util.Map;
import org.apache.tapestry5.commons.util.CollectionFactory;

class MapHolder {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final Map<String, String> startingMap;
    private Map<String, String> localMap;

    MapHolder() {
        this(null);
    }

    MapHolder(Map<String, String> startingMap) {
        this.startingMap = startingMap == null ? EMPTY_MAP : startingMap;
    }

    void put(String key, String value) {
        this.getMutable().put(key, value);
    }

    Map<String, String> getMutable() {
        if (this.localMap == null) {
            this.localMap = CollectionFactory.newMap(this.startingMap);
        }
        return this.localMap;
    }

    void putAll(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        this.getMutable().putAll(map);
    }

    Map<String, String> getResult() {
        return this.localMap != null ? this.localMap : this.startingMap;
    }
}

