/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.mixins;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.MarkupWriterListener;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.model.ComponentModel;

public class PublishServerSideEvents {
    private static final String PUBLISH_COMPONENT_EVENTS_URL_PROPERTY = "url";
    private static final String COMPONENT_EVENTS_ATTRIBUTE_NAME = "data-component-events";
    @Inject
    private ComponentResources resources;

    void beginRender(MarkupWriter writer) {
        Element element = writer.getElement();
        if (element == null) {
            writer.addListener(new BodyElementListener(writer));
        } else {
            writer.addListener(new DelayedListener(writer));
        }
    }

    private void addEventsAttribute(Element element) {
        if (element == null) {
            throw new IllegalStateException("@PublishEvent used inside a page which didn't generate a <body> element");
        }
        ComponentResources containerResources = this.resources.getContainerResources();
        ComponentModel componentModel = containerResources.getComponentModel();
        String metaValue = componentModel.getMeta("meta.publish-component-events");
        JSONArray componentEvents = new JSONArray(metaValue);
        JSONObject events = new JSONObject();
        String existingValue = element.getAttribute(COMPONENT_EVENTS_ATTRIBUTE_NAME);
        if (existingValue != null) {
            JSONObject existing = new JSONObject(existingValue);
            for (String key : existing.keys()) {
                events.put(key, existing.get((Object)key));
            }
        }
        for (int i = 0; i < componentEvents.length(); ++i) {
            String eventName = componentEvents.getString(i);
            JSONObject event = new JSONObject();
            event.put(PUBLISH_COMPONENT_EVENTS_URL_PROPERTY, (Object)containerResources.createEventLink(eventName, new Object[0]).toString());
            events.put(eventName, (Object)event);
        }
        element.forceAttributes(COMPONENT_EVENTS_ATTRIBUTE_NAME, events.toString());
    }

    private final class BodyElementListener
    implements MarkupWriterListener {
        private MarkupWriter writer;

        public BodyElementListener(MarkupWriter writer) {
            this.writer = writer;
        }

        @Override
        public void elementDidStart(Element element) {
            if (element.getName().equals("body")) {
                PublishServerSideEvents.this.addEventsAttribute(element);
                this.writer.removeListener(this);
            }
        }

        @Override
        public void elementDidEnd(Element element) {
        }
    }

    private final class DelayedListener
    implements MarkupWriterListener {
        private MarkupWriter writer;
        private Element element;

        public DelayedListener(MarkupWriter writer) {
            this.writer = writer;
        }

        @Override
        public void elementDidStart(Element element) {
            if (this.element == null) {
                this.element = element;
            }
        }

        @Override
        public void elementDidEnd(Element element) {
            if (this.element == null) {
                throw new IllegalStateException("@PublishEvent used inside a component which didn't generate any HTML elements");
            }
            PublishServerSideEvents.this.addEventsAttribute(this.element);
            this.writer.removeListener(this);
        }
    }
}

