/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.services.ExceptionAnalysis;
import org.apache.tapestry5.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry5.ioc.services.ExceptionInfo;
import org.apache.tapestry5.services.StackTraceElementAnalyzer;

@Import(stylesheet={"ExceptionDisplay.css"}, module={"t5/core/exception-display"})
public class ExceptionDisplay {
    @Parameter(required=true, allowNull=false)
    private Throwable exception;
    @Inject
    private ExceptionAnalyzer analyzer;
    @Property
    private ExceptionInfo info;
    @Property
    private String propertyName;
    @Property
    private StackTraceElement frame;
    @Property
    private List<ExceptionInfo> stack;
    private boolean sawDoFilter;
    @Inject
    @Primary
    private StackTraceElementAnalyzer frameAnalyzer;

    void setupRender() {
        ExceptionAnalysis analysis = this.analyzer.analyze(this.exception);
        this.stack = analysis.getExceptionInfos();
    }

    public Object getPropertyValue() {
        return this.info.getProperty(this.propertyName);
    }

    public String getFrameClass() {
        if (this.sawDoFilter) {
            return "omitted-frame";
        }
        String result = this.frameAnalyzer.classForFrame(this.frame);
        this.sawDoFilter |= this.frame.getMethodName().equals("doFilter");
        return result;
    }

    public Object getLineNumberForFrame() {
        if (this.frame.getLineNumber() < 1) {
            return "";
        }
        return this.frame.getLineNumber();
    }

    public String getFramePackageName() {
        return this.splitClass()[0];
    }

    public String getFrameClassName() {
        return this.splitClass()[1];
    }

    private String[] splitClass() {
        String name = this.frame.getClassName();
        int dotx = name.lastIndexOf(46);
        if (dotx < 0) {
            return new String[]{"", name};
        }
        return new String[]{name.substring(0, dotx), name.substring(dotx)};
    }
}

