/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResourceMinimizer;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.slf4j.Logger;

public abstract class AbstractMinimizer
implements ResourceMinimizer {
    private static final double NANOS_TO_MILLIS = 1.0E-6;
    protected final Logger logger;
    protected final OperationTracker tracker;
    private final AssetChecksumGenerator checksumGenerator;
    private final String resourceType;

    public AbstractMinimizer(Logger logger, OperationTracker tracker, AssetChecksumGenerator checksumGenerator, String resourceType) {
        this.logger = logger;
        this.tracker = tracker;
        this.resourceType = resourceType;
        this.checksumGenerator = checksumGenerator;
    }

    public StreamableResource minimize(final StreamableResource input) throws IOException {
        if (!this.isEnabled(input)) {
            return input;
        }
        long startNanos = System.nanoTime();
        final ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        this.tracker.perform("Minimizing " + input, (IOOperation)new IOOperation<Void>(){

            public Void perform() throws IOException {
                InputStream in = AbstractMinimizer.this.doMinimize(input);
                TapestryInternalUtils.copy((InputStream)in, (OutputStream)bos);
                in.close();
                return null;
            }
        });
        StreamableResourceImpl output = new StreamableResourceImpl("minimized " + input.getDescription(), input.getContentType(), CompressionStatus.COMPRESSABLE, input.getLastModified(), new BytestreamCache(bos), this.checksumGenerator, input.getResponseCustomizer());
        if (this.logger.isInfoEnabled()) {
            long elapsedNanos = System.nanoTime() - startNanos;
            int inputSize = input.getSize();
            int outputSize = output.getSize();
            double elapsedMillis = (double)elapsedNanos * 1.0E-6;
            double reduction = 100.0 * (double)(inputSize - outputSize) / (double)inputSize;
            this.logger.info(String.format("Minimized %s (%,d input bytes of %s to %,d output bytes in %.2f ms, %.2f%% reduction)", input.getDescription(), inputSize, this.resourceType, outputSize, elapsedMillis, reduction));
        }
        return output;
    }

    protected abstract InputStream doMinimize(StreamableResource var1) throws IOException;

    protected boolean isEnabled(StreamableResource resource) {
        return true;
    }
}

