/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class JSONStringer {
    final StringBuilder out = new StringBuilder();
    private final List<Scope> stack = new ArrayList<Scope>();
    private final String indent;

    JSONStringer() {
        this.indent = null;
    }

    JSONStringer(int indentSpaces) {
        char[] indentChars = new char[indentSpaces];
        Arrays.fill(indentChars, ' ');
        this.indent = new String(indentChars);
    }

    JSONStringer open(Scope empty, String openBracket) {
        if (this.stack.isEmpty() && this.out.length() > 0) {
            throw new RuntimeException("Nesting problem: multiple top-level roots");
        }
        this.beforeValue();
        this.stack.add(empty);
        this.out.append(openBracket);
        return this;
    }

    JSONStringer close(Scope empty, Scope nonempty, String closeBracket) {
        Scope context = this.peek();
        if (context != nonempty && context != empty) {
            throw new RuntimeException("Nesting problem");
        }
        this.stack.remove(this.stack.size() - 1);
        if (context == nonempty) {
            this.newline();
        }
        this.out.append(closeBracket);
        return this;
    }

    private Scope peek() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Nesting problem");
        }
        return this.stack.get(this.stack.size() - 1);
    }

    private void replaceTop(Scope topOfStack) {
        this.stack.set(this.stack.size() - 1, topOfStack);
    }

    void string(String value) {
        this.out.append("\"");
        char currentChar = '\u0000';
        int length = value.length();
        block9: for (int i = 0; i < length; ++i) {
            char previousChar = currentChar;
            currentChar = value.charAt(i);
            switch (currentChar) {
                case '\"': 
                case '\\': {
                    this.out.append('\\').append(currentChar);
                    continue block9;
                }
                case '/': {
                    if (previousChar == '<') {
                        this.out.append('\\');
                    }
                    this.out.append(currentChar);
                    continue block9;
                }
                case '\t': {
                    this.out.append("\\t");
                    continue block9;
                }
                case '\b': {
                    this.out.append("\\b");
                    continue block9;
                }
                case '\n': {
                    this.out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.out.append("\\r");
                    continue block9;
                }
                case '\f': {
                    this.out.append("\\f");
                    continue block9;
                }
                default: {
                    if (currentChar <= '\u001f' || currentChar >= '\u0080' && currentChar < '\u00a0' || currentChar >= '\u2000' && currentChar < '\u2100') {
                        this.out.append(String.format("\\u%04x", currentChar));
                        continue block9;
                    }
                    this.out.append(currentChar);
                }
            }
        }
        this.out.append("\"");
    }

    private void newline() {
        if (this.indent == null) {
            return;
        }
        this.out.append("\n");
        for (int i = 0; i < this.stack.size(); ++i) {
            this.out.append(this.indent);
        }
    }

    private void beforeValue() {
        if (this.stack.isEmpty()) {
            return;
        }
        Scope context = this.peek();
        if (context == Scope.EMPTY_ARRAY) {
            this.replaceTop(Scope.NONEMPTY_ARRAY);
            this.newline();
        } else if (context == Scope.NONEMPTY_ARRAY) {
            this.out.append(',');
            this.newline();
        } else if (context == Scope.DANGLING_KEY) {
            this.out.append(this.indent == null ? ":" : ": ");
            this.replaceTop(Scope.NONEMPTY_OBJECT);
        } else if (context != Scope.NULL) {
            throw new RuntimeException("Nesting problem");
        }
    }

    public String toString() {
        return this.out.length() == 0 ? null : this.out.toString();
    }

    static enum Scope {
        EMPTY_ARRAY,
        NONEMPTY_ARRAY,
        EMPTY_OBJECT,
        DANGLING_KEY,
        NONEMPTY_OBJECT,
        NULL;

    }
}

