/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.SymbolProvider;

public class ResourceSymbolProvider
implements SymbolProvider {
    private final Resource resource;
    private final Map<String, String> properties = CollectionFactory.newCaseInsensitiveMap();

    public ResourceSymbolProvider(Resource resource) {
        this.resource = resource;
        this.readProperties();
    }

    private void readProperties() {
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = this.resource.openStream();
            p.load(is);
            is.close();
            is = null;
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = entry.getKey().toString();
                this.properties.put(key, p.getProperty(key));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            InternalUtils.close(is);
        }
    }

    @Override
    public String valueForSymbol(String symbolName) {
        return this.properties.get(symbolName);
    }
}

