/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ChainBuilder;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.WhenCallback;

public class ChainBuilderImpl
implements ChainBuilder {
    private final PlasticProxyFactory proxyFactory;

    public ChainBuilderImpl(@Builtin PlasticProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public <T> T build(final Class<T> commandInterface, List<T> commands) {
        Object[] array = (Object[])Array.newInstance(commandInterface, commands.size());
        final Object[] commandsArray = commands.toArray(array);
        ClassInstantiator instantiator = this.proxyFactory.createProxy(commandInterface, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                PlasticField commandsField = plasticClass.introduceField(commandsArray.getClass(), "commands").inject((Object)commandsArray);
                for (Method method : commandInterface.getMethods()) {
                    if (Modifier.isStatic(method.getModifiers())) continue;
                    ChainBuilderImpl.this.implementMethod(plasticClass, method, commandsField);
                }
                plasticClass.addToString(String.format("<Command chain of %s>", commandInterface.getName()));
            }
        });
        return (T)instantiator.newInstance();
    }

    private void implementMethod(PlasticClass plasticClass, final Method method, final PlasticField commandsField) {
        plasticClass.introduceMethod(method).changeImplementation(new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.loadThis().getField(commandsField).iterateArray(new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        boolean wide;
                        builder.loadArguments().invoke(method);
                        Class<?> returnType = method.getReturnType();
                        if (returnType == Void.TYPE) {
                            return;
                        }
                        boolean bl = wide = returnType == Long.TYPE || returnType == Double.TYPE;
                        if (wide) {
                            builder.dupeWide();
                        } else {
                            builder.dupe();
                        }
                        if (returnType == Float.TYPE) {
                            builder.loadConstant((Object)Float.valueOf(0.0f)).compareSpecial("float");
                        }
                        if (returnType == Long.TYPE) {
                            builder.loadConstant((Object)0L).compareSpecial("long");
                        }
                        if (returnType == Double.TYPE) {
                            builder.loadConstant((Object)0.0).compareSpecial("double");
                        }
                        Condition condition = returnType.isPrimitive() ? Condition.NON_ZERO : Condition.NON_NULL;
                        builder.when(condition, new WhenCallback(){

                            public void ifTrue(InstructionBuilder builder) {
                                builder.returnResult();
                            }

                            public void ifFalse(InstructionBuilder builder) {
                                if (wide) {
                                    builder.popWide();
                                } else {
                                    builder.pop();
                                }
                            }
                        });
                    }
                });
                builder.returnDefaultValue();
            }
        });
    }
}

