/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import jakarta.ws.rs.core.Response;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.governance.handler.InstanceIsolationHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.CircuitBreakerPolicy;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConsumerInstanceIsolationFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerInstanceIsolationFilter.class);
    private final InstanceIsolationHandler instanceIsolationHandler;
    private DiscoveryManager discoveryManager;

    @Autowired
    public ConsumerInstanceIsolationFilter(InstanceIsolationHandler instanceIsolationHandler) {
        this.instanceIsolationHandler = instanceIsolationHandler;
    }

    @Autowired
    public void setDiscoveryManager(DiscoveryManager discoveryManager) {
        this.discoveryManager = discoveryManager;
    }

    public int getOrder() {
        return 1050;
    }

    public String getName() {
        return "instance-isolation";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (invocation.getEndpoint() == null) {
            return CompletableFuture.failedFuture((Throwable)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)new CommonExceptionData("instance isolation should work after load balancer.")));
        }
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest((Invocation)invocation);
        CircuitBreakerPolicy circuitBreakerPolicy = this.instanceIsolationHandler.matchPolicy(request);
        if (circuitBreakerPolicy != null && circuitBreakerPolicy.isForceOpen()) {
            return CompletableFuture.failedFuture((Throwable)new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, (Object)new CommonExceptionData("Policy \" + circuitBreakerPolicy.getName() + \" forced open and deny requests\"")));
        }
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation, nextNode);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        this.addCircuitBreaker((Decorators.DecorateCompletionStage<Response>)dcs, request);
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                future.complete((Response)r);
                return;
            }
            if (e instanceof CallNotPermittedException) {
                LOGGER.warn("instance isolation circuitBreaker is open by policy : {}", (Object)e.getMessage());
                this.discoveryManager.onInstanceIsolated(invocation.getEndpoint().getMicroserviceInstance(), Duration.parse(circuitBreakerPolicy.getWaitDurationInOpenState()).toMillis());
                future.complete(Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, (Object)new CommonExceptionData("instance isolation circuitBreaker is open."))));
            } else {
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    private void addCircuitBreaker(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequestExtractor request) {
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.instanceIsolationHandler.getActuator(request);
        if (circuitBreaker != null) {
            dcs.withCircuitBreaker(circuitBreaker);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation, FilterNode nextNode) {
        return () -> nextNode.onFilter(invocation);
    }
}

