/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracer;
import org.apache.servicecomb.swagger.invocation.context.ContextUtils;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;

class ZipkinTracingAdviser {
    static final String CALL_PATH = "call.path";
    private final Tracer tracer;

    ZipkinTracingAdviser(Tracer tracer) {
        this.tracer = tracer;
    }

    <T> T invoke(String spanName, String path, ThrowableSupplier<T> supplier) throws Throwable {
        Span span = this.createSpan(spanName, path);
        try {
            T t;
            block11: {
                Tracer.SpanInScope spanInScope = this.tracer.withSpanInScope(span);
                try {
                    t = supplier.get();
                    if (spanInScope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (spanInScope != null) {
                            try {
                                spanInScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        span.tag("error", throwable3.getClass().getSimpleName() + ": " + throwable3.getMessage());
                        throw throwable3;
                    }
                }
                spanInScope.close();
            }
            return t;
        }
        finally {
            span.finish();
        }
    }

    private Span createSpan(String spanName, String path) {
        InvocationContext context = ContextUtils.getInvocationContext();
        Span currentSpan = null;
        if (context != null) {
            currentSpan = (Span)context.getLocalContext("x-trace-span");
        }
        if (currentSpan == null) {
            currentSpan = this.tracer.currentSpan();
        }
        if (currentSpan != null) {
            return this.tracer.newChild(currentSpan.context()).name(spanName).tag(CALL_PATH, path).start();
        }
        return this.tracer.newTrace().name(spanName).tag(CALL_PATH, path).start();
    }

    static interface ThrowableSupplier<T> {
        public T get() throws Throwable;
    }
}

