/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerParameterAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class ParameterParameterAnnotationProcessor
extends SwaggerParameterAnnotationProcessor<Parameter> {
    @Override
    public Class<?> getProcessType() {
        return Parameter.class;
    }

    @Override
    public String getParameterName(Parameter annotation) {
        if (StringUtils.isNotEmpty((CharSequence)annotation.name())) {
            return annotation.name();
        }
        return null;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, ParameterGenerator parameterGenerator, Parameter annotation) {
        if (annotation.schema() != null && annotation.schema().implementation() != null && annotation.schema().implementation() != Void.class) {
            parameterGenerator.getParameterGeneratorContext().setParameterType(TypeFactory.defaultInstance().constructType((Type)annotation.schema().implementation()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getParameterName(annotation))) {
            parameterGenerator.getParameterGeneratorContext().setParameterName(this.getParameterName(annotation));
        }
        if (annotation.in() != null && annotation.in() != ParameterIn.DEFAULT) {
            parameterGenerator.setHttpParameterType(HttpParameterType.from(annotation.in()));
        }
        if (Explode.TRUE.equals((Object)annotation.explode())) {
            parameterGenerator.getParameterGeneratorContext().setExplode(true);
        }
        if (Explode.FALSE.equals((Object)annotation.explode())) {
            parameterGenerator.getParameterGeneratorContext().setExplode(false);
        }
        parameterGenerator.getParameterGeneratorContext().setRequired(annotation.required());
    }
}

