/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.util.List;
import org.apache.servicecomb.loadbalance.ExtensionsFactory;
import org.apache.servicecomb.loadbalance.RoundRobinRuleExt;
import org.apache.servicecomb.loadbalance.RuleExt;

public class ExtensionsManager {
    private final List<ExtensionsFactory> extensionsFactories;

    public ExtensionsManager(List<ExtensionsFactory> extensionsFactories) {
        this.extensionsFactories = extensionsFactories;
    }

    public RuleExt createLoadBalancerRule(String ruleStrategyName) {
        RuleExt rule = null;
        for (ExtensionsFactory factory : this.extensionsFactories) {
            if (!factory.isSupport("strategy.name", ruleStrategyName)) continue;
            rule = factory.createLoadBalancerRule(ruleStrategyName);
            break;
        }
        if (rule == null) {
            rule = new RoundRobinRuleExt();
        }
        return rule;
    }
}

