/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.util.Map;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.springframework.core.env.Environment;

public final class Configuration {
    public static final String ROOT = "servicecomb.loadbalance.";
    public static final String RULE_STRATEGY_GLOBAL = "servicecomb.loadbalance.strategy.name";
    public static final String RULE_STRATEGY_NAME = "strategy.name";
    public static final String ROOT_20 = "ribbon.";
    public static final String SESSION_TIMEOUT_IN_SECONDS = "SessionStickinessRule.sessionTimeoutInSeconds";
    public static final String SUCCESSIVE_FAILED_TIMES = "SessionStickinessRule.successiveFailedTimes";
    public static final String FILTER_ISOLATION = "isolation.";
    public static final String FILTER_MAX_SINGLE_TEST_WINDOW = "maxSingleTestWindow";
    public static final String TRANSACTIONCONTROL_OPTIONS_PREFIX_PATTERN = "servicecomb.loadbalance.%s.transactionControl.options";
    public static final Configuration INSTANCE = new Configuration();

    private Configuration() {
    }

    public RuleType getRuleStrategyName(Invocation invocation) {
        String value = Configuration.getStringProperty(null, ROOT + invocation.getMicroserviceName() + "." + invocation.getSchemaId() + "." + invocation.getOperationName() + ".strategy.name");
        if (value != null) {
            return new RuleType(2, value);
        }
        value = Configuration.getStringProperty(null, ROOT + invocation.getMicroserviceName() + "." + invocation.getSchemaId() + ".strategy.name");
        if (value != null) {
            return new RuleType(1, value);
        }
        value = Configuration.getStringProperty(null, ROOT + invocation.getMicroserviceName() + ".strategy.name");
        if (value != null) {
            return new RuleType(1, value);
        }
        return new RuleType(1, Configuration.getStringProperty("RoundRobin", RULE_STRATEGY_GLOBAL));
    }

    public int getSessionTimeoutInSeconds(String microservice) {
        int defaultValue = 30;
        String p = Configuration.getStringProperty("30", ROOT + microservice + ".SessionStickinessRule.sessionTimeoutInSeconds", "servicecomb.loadbalance.SessionStickinessRule.sessionTimeoutInSeconds");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 30;
        }
    }

    public int getSuccessiveFailedTimes(String microservice) {
        int defaultValue = 5;
        String p = Configuration.getStringProperty("5", ROOT + microservice + ".SessionStickinessRule.successiveFailedTimes", "servicecomb.loadbalance.SessionStickinessRule.successiveFailedTimes");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public int getMaxSingleTestWindow() {
        int defaultValue = 60000;
        String p = Configuration.getStringProperty(Integer.toString(60000), "servicecomb.loadbalance.isolation.maxSingleTestWindow");
        try {
            int result = Integer.parseInt(p);
            if (result >= 0) {
                return result;
            }
            return 60000;
        }
        catch (NumberFormatException e) {
            return 60000;
        }
    }

    public Map<String, String> getFlowsplitFilterOptions(String microservice) {
        String keyPrefix = String.format(TRANSACTIONCONTROL_OPTIONS_PREFIX_PATTERN, microservice);
        return ConfigUtil.stringPropertiesWithPrefix((Environment)LegacyPropertyFactory.getEnvironment(), (String)keyPrefix);
    }

    public static String getStringProperty(String defaultValue, String ... keys) {
        for (String key : keys) {
            String property = LegacyPropertyFactory.getStringProperty((String)key);
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }

    public record RuleType(int type, String value) {
        public static final int TYPE_SCHEMA = 1;
        public static final int TYPE_OPERATION = 2;

        public String getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }
    }
}

