/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.tcp;

import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class TcpConnection {
    protected String protocol;
    protected String zipName;
    protected NetSocket netSocket;
    protected Context context;
    private final Queue<Buffer> writeQueue = new ConcurrentLinkedQueue<Buffer>();
    private final AtomicLong writeQueueSize = new AtomicLong();

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getZipName() {
        return this.zipName;
    }

    public void setZipName(String zipName) {
        this.zipName = zipName;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public NetSocket getNetSocket() {
        return this.netSocket;
    }

    public void initNetSocket(NetSocketImpl netSocket) {
        this.netSocket = netSocket;
        this.context = netSocket.getContext();
    }

    public void write(Buffer buf) {
        this.writeQueue.add(buf);
        long oldSize = this.writeQueueSize.getAndIncrement();
        if (oldSize == 0L) {
            this.scheduleWrite();
        }
    }

    protected void scheduleWrite() {
        this.context.runOnContext(v -> this.writeInContext());
    }

    protected void writeInContext() {
        Buffer buf;
        while ((buf = this.writeQueue.poll()) != null) {
            this.writeQueueSize.decrementAndGet();
            this.netSocket.write((Object)buf);
        }
    }
}

