/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.registry.discovery;

import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.registry.discovery.AbstractEndpointDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EndpointDiscoveryFilter
extends AbstractEndpointDiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointDiscoveryFilter.class);
    protected SCBEngine scbEngine;

    @Autowired
    public void setScbEngine(SCBEngine scbEngine) {
        this.scbEngine = scbEngine;
    }

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    protected String findTransportName(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)((Object)context.getInputParameters());
        return invocation.getConfigTransportName();
    }

    protected Object createEndpoint(DiscoveryContext context, String transportName, String endpoint, StatefulDiscoveryInstance instance) {
        Transport transport = this.scbEngine.getTransportManager().findTransport(transportName);
        if (transport == null) {
            LOGGER.info("not deployed transport {}, ignore {}.", (Object)transportName, (Object)endpoint);
            return null;
        }
        return new Endpoint(transport, endpoint, (DiscoveryInstance)instance);
    }
}

