/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.governance;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.swagger.SwaggerUtils;

public final class MatchType {
    public static final String REST = "rest";
    public static final String RPC = "rpc";

    public static GovernanceRequestExtractor createGovHttpRequest(Invocation invocation) {
        return new GovernanceRequestExtractorImpl(invocation);
    }

    private static class GovernanceRequestExtractorImpl
    implements GovernanceRequestExtractor {
        private final Invocation invocation;

        private GovernanceRequestExtractorImpl(Invocation invocation) {
            this.invocation = invocation;
        }

        public String apiPath() {
            if (MatchType.REST.equalsIgnoreCase(this.invocation.getOperationMeta().getConfig().getGovernanceMatchType())) {
                if (!this.invocation.isProducer()) {
                    return SwaggerUtils.concatAbsolutePath((OpenAPI)this.invocation.getSchemaMeta().getSwagger(), (String)this.invocation.getOperationMeta().getOperationPath());
                }
                if (this.invocation.getRequestEx() != null) {
                    return this.invocation.getRequestEx().getRequestURI();
                }
            }
            if (!this.invocation.isProducer()) {
                return this.invocation.getOperationMeta().getMicroserviceQualifiedName();
            }
            return this.invocation.getOperationMeta().getSchemaQualifiedName();
        }

        public String method() {
            return this.invocation.getOperationMeta().getHttpMethod();
        }

        public String header(String key) {
            Map<String, Object> arguments = this.invocation.getSwaggerArguments();
            if (arguments != null && arguments.get(key) != null) {
                return arguments.get(key).toString();
            }
            if (this.invocation.getContext(key) != null) {
                return this.invocation.getContext(key);
            }
            if (this.invocation.getRequestEx() != null) {
                return this.invocation.getRequestEx().getHeader(key);
            }
            return null;
        }

        public String query(String key) {
            HttpServletRequestEx requestEx = this.invocation.getRequestEx();
            if (requestEx == null) {
                return null;
            }
            return requestEx.getParameter(key);
        }

        public String instanceId() {
            if (!this.invocation.isProducer() && this.invocation.getEndpoint() != null && this.invocation.getEndpoint().getMicroserviceInstance() != null) {
                return this.invocation.getEndpoint().getMicroserviceInstance().getInstanceId();
            }
            return null;
        }

        public String serviceName() {
            if (!this.invocation.isProducer()) {
                return this.invocation.getMicroserviceName();
            }
            return null;
        }

        public Object sourceRequest() {
            return this.invocation;
        }
    }
}

