/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.response;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.response.ResponseMetaMapper;

public class ResponsesMeta {
    private static final JavaType COMMON_EXCEPTION_JAVA_TYPE = SimpleType.constructUnsafe(CommonExceptionData.class);
    private static final JavaType OBJECT_JAVA_TYPE = SimpleType.constructUnsafe(Object.class);
    private static final ResponseMetaMapper GLOBAL_DEFAULT_MAPPER = (ResponseMetaMapper)SPIServiceUtils.getPriorityHighestService(ResponseMetaMapper.class);
    private final Map<Integer, JavaType> responseMap = new HashMap<Integer, JavaType>();
    private JavaType defaultResponse;

    public void init(OpenAPI swagger, Operation operation) {
        if (this.responseMap.isEmpty()) {
            this.responseMap.put(Response.Status.OK.getStatusCode(), OBJECT_JAVA_TYPE);
            this.initGlobalDefaultMapper();
        }
        for (Map.Entry entry : operation.getResponses().entrySet()) {
            if (((ApiResponse)entry.getValue()).getContent() == null || ((ApiResponse)entry.getValue()).getContent().size() == 0) continue;
            String mediaType = (String)((ApiResponse)entry.getValue()).getContent().keySet().iterator().next();
            JavaType javaType = ConverterMgr.findJavaType((OpenAPI)swagger, (Schema)SwaggerUtils.getSchema((OpenAPI)swagger, (Schema)((MediaType)((ApiResponse)entry.getValue()).getContent().get((Object)mediaType)).getSchema()));
            if ("default".equals(entry.getKey())) {
                this.defaultResponse = javaType;
                continue;
            }
            Integer statusCode = Integer.parseInt((String)entry.getKey());
            JavaType existing = this.responseMap.get(statusCode);
            if (existing != null && ReflectionUtils.isVoid((Type)javaType)) continue;
            this.responseMap.put(statusCode, javaType);
        }
        this.responseMap.putIfAbsent(490, COMMON_EXCEPTION_JAVA_TYPE);
        this.responseMap.putIfAbsent(590, COMMON_EXCEPTION_JAVA_TYPE);
        this.responseMap.putIfAbsent(Response.Status.TOO_MANY_REQUESTS.getStatusCode(), COMMON_EXCEPTION_JAVA_TYPE);
        this.responseMap.putIfAbsent(Response.Status.REQUEST_TIMEOUT.getStatusCode(), COMMON_EXCEPTION_JAVA_TYPE);
        this.responseMap.putIfAbsent(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), COMMON_EXCEPTION_JAVA_TYPE);
        if (this.defaultResponse == null) {
            this.defaultResponse = OBJECT_JAVA_TYPE;
        }
    }

    public void cloneTo(ResponsesMeta target) {
        target.defaultResponse = this.defaultResponse;
        target.responseMap.putAll(this.responseMap);
    }

    protected void initGlobalDefaultMapper() {
        Map<Integer, JavaType> mappers;
        if (GLOBAL_DEFAULT_MAPPER != null && (mappers = GLOBAL_DEFAULT_MAPPER.getMapper()) != null) {
            this.responseMap.putAll(mappers);
        }
    }

    public JavaType findResponseType(int statusCode) {
        JavaType responseType = this.responseMap.get(statusCode);
        if (responseType == null) {
            if (HttpStatus.isSuccess((int)statusCode)) {
                return this.responseMap.get(Response.Status.OK.getStatusCode());
            }
            return this.defaultResponse;
        }
        return responseType;
    }

    public void setResponseType(int statusCode, JavaType javaType) {
        this.responseMap.put(statusCode, javaType);
    }
}

