/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.definition.path;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.common.rest.definition.path.PathVarParamWriter;
import org.apache.servicecomb.common.rest.definition.path.QueryVarParamWriter;
import org.apache.servicecomb.common.rest.definition.path.StaticUrlParamWriter;
import org.apache.servicecomb.common.rest.definition.path.UrlParamWriter;

public class URLPathBuilder {
    private final List<UrlParamWriter> pathParamWriterList = new ArrayList<UrlParamWriter>();
    private final List<UrlParamWriter> queryParamWriterList = new ArrayList<UrlParamWriter>();
    private static final String SLASH = "/";

    public URLPathBuilder(String rawPath, Map<String, RestParam> paramMap) {
        this.initPathWriterList(rawPath, paramMap);
        this.initQueryWriterList(paramMap);
    }

    private void initQueryWriterList(Map<String, RestParam> paramMap) {
        for (RestParam param : paramMap.values()) {
            if (!"query".equals(param.getParamProcessor().getProcessorType())) continue;
            QueryVarParamWriter dynamicWriter = new QueryVarParamWriter(param);
            this.queryParamWriterList.add(dynamicWriter);
        }
    }

    private void initPathWriterList(String rawPath, Map<String, RestParam> paramMap) {
        if (!((String)rawPath).startsWith(SLASH)) {
            rawPath = SLASH + (String)rawPath;
        }
        StringBuilder tmpPath = new StringBuilder();
        for (int idx = 0; idx < ((String)rawPath).length(); ++idx) {
            char currentChar = ((String)rawPath).charAt(idx);
            if (currentChar == '{') {
                if (tmpPath.length() == 0) continue;
                this.pathParamWriterList.add(new StaticUrlParamWriter(tmpPath.toString()));
                tmpPath.setLength(0);
                continue;
            }
            if (currentChar == '}') {
                String tmpPathStr;
                if (tmpPath.length() == 0) continue;
                String pathParamName = tmpPathStr = tmpPath.toString();
                if (tmpPathStr.contains(":")) {
                    pathParamName = tmpPathStr.split(":", 2)[0].trim();
                }
                RestParam param = paramMap.get(pathParamName);
                this.pathParamWriterList.add(new PathVarParamWriter(param));
                tmpPath.setLength(0);
                continue;
            }
            tmpPath.append(currentChar);
        }
        if (tmpPath.length() != 0) {
            this.pathParamWriterList.add(new StaticUrlParamWriter(tmpPath.toString()));
        }
    }

    public String createRequestPath(Map<String, Object> args) throws Exception {
        URLPathStringBuilder builder = new URLPathStringBuilder();
        this.genPathString(builder, args);
        this.genQueryString(builder, args);
        return builder.build();
    }

    public String createPathString(Map<String, Object> args) throws Exception {
        URLPathStringBuilder builder = new URLPathStringBuilder();
        this.genPathString(builder, args);
        return builder.build();
    }

    private void genPathString(URLPathStringBuilder builder, Map<String, Object> args) throws Exception {
        for (UrlParamWriter writer : this.pathParamWriterList) {
            writer.write(builder, args);
        }
    }

    private void genQueryString(URLPathStringBuilder builder, Map<String, Object> args) throws Exception {
        for (UrlParamWriter writer : this.queryParamWriterList) {
            writer.write(builder, args);
        }
    }

    public static class URLPathStringBuilder {
        private final StringBuilder stringBuilder = new StringBuilder();
        private boolean queryPrefixNotWrite = true;

        public URLPathStringBuilder appendPath(String s) {
            this.stringBuilder.append(s);
            return this;
        }

        public URLPathStringBuilder appendQuery(String name, String encodedValue) {
            if (this.queryPrefixNotWrite) {
                this.stringBuilder.append('?');
                this.queryPrefixNotWrite = false;
            } else {
                this.stringBuilder.append('&');
            }
            this.stringBuilder.append(name).append("=").append(encodedValue);
            return this;
        }

        public String build() {
            return this.stringBuilder.toString();
        }
    }
}

